#pragma once

#include "infra/yp_service_discovery/api/api.pb.h"

#include <util/generic/ptr.h>
#include <util/datetime/base.h>


namespace NYP::NServiceDiscovery::NTesting {

    class TSDServer {
    public:
        struct TOptions {
            ui16 Port = 8080;
            size_t Threads = 1;
        public:
            TOptions() = default;

            TOptions(ui16 port)
                : Port(port)
            {
            }

            TOptions& SetPort(ui16 v) {
                Port = v;
                return *this;
            }
        };

        explicit TSDServer(const TOptions& option);
        ~TSDServer();

        void Start(TDuration timeout = TDuration::Seconds(5));
        void Stop();

        void Set(const NApi::TReqResolveEndpoints& request, const NApi::TRspResolveEndpoints& response);
        void Remove(const NApi::TReqResolveEndpoints& request);

        const TOptions& GetOptions() const {
            return Options_;
        }

        size_t GetRequestCount() const;
    private:
        struct TImpl;
        THolder<TImpl> Impl_;

        const TOptions Options_;
    };

}
