#include "stat.h"

namespace NYP::NServiceDiscovery {
    TAtomicSharedPtr<IStatCounterImpl> StandaloneCounterFactory(const TString&) {
        class TStatCounterImpl
            : public IStatCounterImpl
        {
        public:
            void Inc() override {
                AtomicIncrement(Counter_);
            }

            TAtomicBase Get() const override {
                return AtomicGet(Counter_);
            }

            void Set(TAtomicBase v) override {
                AtomicSet(Counter_, v);
            }
        private:
            TAtomic Counter_ = 0;
        };

        return MakeAtomicShared<TStatCounterImpl>();
    }
}
