#pragma once

#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/generic/strbuf.h>

#include <functional>

namespace NYP::NServiceDiscovery {
    class IStatCounterImpl {
    public:
        virtual ~IStatCounterImpl() {}

        virtual void Inc() = 0;
        virtual TAtomicBase Get() const = 0;
        virtual void Set(TAtomicBase v) = 0;

        virtual void Detach() {};
    };

    using TCounterFactory = std::function<TAtomicSharedPtr<IStatCounterImpl>(const TString& name)>;

    TAtomicSharedPtr<IStatCounterImpl> StandaloneCounterFactory(const TString&);

    class TStatCounter
        : public TNonCopyable
    {
    public:
        explicit TStatCounter(TAtomicSharedPtr<IStatCounterImpl>&& impl)
            : Counter_(std::move(impl))
        {
        }

        TStatCounter(const TString& name, TCounterFactory& f)
            : Counter_(f(name))
        {
        }

        ~TStatCounter() {
            if (Counter_) {
                Counter_->Detach();
            }
        }

        operator TAtomicBase() const {
            return Get();
        }

        TAtomicBase Get() const {
            return Counter_->Get();
        }

        TStatCounter& operator++() {
            Counter_->Inc();
            return *this;
        }

        void Set(TAtomicBase v) {
            Counter_->Set(v);
        }
    private:
        TAtomicSharedPtr<IStatCounterImpl> Counter_;
    };
}

