#pragma once

#include "endpointset.h"

#include <util/system/spinlock.h>
#include <util/generic/ptr.h>

namespace NYP::NServiceDiscovery {
    class IEndpointSetSubscriber
        : public TAtomicRefCount<IEndpointSetSubscriber>
    {
    public:
        virtual TEndpointSetEx GetEndpointSet() const = 0;

        virtual ~IEndpointSetSubscriber() {}
    };

    using IEndpointSetSubscriberRef = TIntrusivePtr<IEndpointSetSubscriber>;

    class IEndpointSetProvider {
    public:
        virtual ~IEndpointSetProvider() {
        }

        virtual bool AllowUpdate() {
            return true;
        }

        virtual void Update(const TEndpointSetEx& endpointSet) = 0;

        // Called when only any of ready-flags was changed.
        virtual void UpdateReadiness(const TEndpointSetEx& endpointSet) {
            SetActiveEndpointSetInfo(endpointSet.Info);
        }

        void SetActiveEndpointSetInfo(const TEndpointSetInfo& info) {
            with_lock (Lock_) {
                Active_ = info;
            }
        }

        TEndpointSetInfo GetActiveEndpointSetInfo() const {
            with_lock (Lock_) {
                return Active_;
            }
        }
    private:
        TAdaptiveLock Lock_;
        TEndpointSetInfo Active_;
    };
}
