#include "manager.h"
#include "helpers.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/env.h>

#include <util/system/fs.h>

using namespace NYP::NServiceDiscovery;

Y_UNIT_TEST_SUITE(TLog) {
    const TString logFile = "./log";


    Y_UNIT_TEST(TestWrite) {
        NFs::Remove(logFile);

        UNIT_ASSERT(!NFs::Exists(logFile));

        TLog log(logFile);
        TEndpointSetManager manager(DummyRequester, TestClientName);
        manager.AssignLog(&log);

        TEndpointSetKey key1("test-cluster", "test-service");

        manager.RegisterEndpointSet<TProvider>(key1);
        manager.Start(TDuration::MilliSeconds(10));
        WaitUpdate(manager);

        UNIT_ASSERT(GetFileLength(logFile) > 0);
    }

    const TString rotated = "./log.1";

    Y_UNIT_TEST(TestReopen) {
        NFs::Remove(logFile);
        NFs::Remove(rotated);

        UNIT_ASSERT(!NFs::Exists(logFile) && !NFs::Exists(rotated));

        TLog log(logFile);
        TEndpointSetManager manager(DummyRequester, TestClientName);
        manager.AssignLog(&log);

        TEndpointSetKey key1("test-cluster", "test-service");

        manager.RegisterEndpointSet<TProvider>(key1);
        manager.Start(TDuration::MilliSeconds(10));
        WaitUpdate(manager);

        for (size_t i = 0; i < 3; ++i) {
            NFs::Rename(logFile, rotated);

            for (size_t j = 0; j < 3; ++j) {
                const auto prev = GetFileLength(rotated);
                WaitUpdate(manager);
                UNIT_ASSERT(GetFileLength(rotated) > prev);
                UNIT_ASSERT(!NFs::Exists(logFile));
            }

            log.ReopenLog();

            for (size_t j = 0; j < 3; ++j) {
                WaitUpdate(manager);
                UNIT_ASSERT(NFs::Exists(logFile));
                const auto prev1 = GetFileLength(logFile);
                const auto prev2 = GetFileLength(rotated);
                WaitUpdate(manager);

                UNIT_ASSERT(GetFileLength(logFile) > prev1);
                UNIT_ASSERT(GetFileLength(rotated) == prev2);
            }
        }
    }
}
