#include "http_resolver.h"

#include <infra/yp_service_discovery/libs/sdlib/server_mock/server.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <library/cpp/coroutine/engine/impl.h>

#include <library/cpp/protobuf/util/is_equal.h>

using namespace NYP::NServiceDiscovery;

Y_UNIT_TEST_SUITE(ServerMock) {
    struct TEnv {
        TPortManager PM;
        NTesting::TSDServer Server;
    public:
        TEnv()
            : Server(PM.GetPort())
        {
            Server.Start();
        }

        ~TEnv() {
            Server.Stop();
        }
    };

    Y_UNIT_TEST(TestSimple) {
        TEnv env;
    }

    void TestResolve(TEnv& env) {
        NApi::TReqResolveEndpoints req;
        req.set_cluster_name("test-cluster");
        req.set_endpoint_set_id("test-id");

        THttpResolver resolver({"localhost", env.Server.GetOptions().Port}, TDuration::Seconds(1), TDuration::Seconds(5));
        resolver.Init();

        NApi::TRspResolveEndpoints expected;
        NApi::TRspResolveEndpoints rsp;
        resolver.ResolveOne(req, rsp);
        UNIT_ASSERT(NProtoBuf::IsEqual(rsp, expected));

        NApi::TEndpoint* endpoint = expected.mutable_endpoint_set()->add_endpoints();
        endpoint->set_fqdn("test-fqdn.yandex.ru");
        endpoint->set_port(8080);
        endpoint->set_ip4_address("127.0.0.1");

        env.Server.Set(req, expected);

        resolver.ResolveOne(req, rsp);
        UNIT_ASSERT(NProtoBuf::IsEqual(rsp, expected));

        expected.Clear();
        env.Server.Remove(req);
        resolver.ResolveOne(req, rsp);
        UNIT_ASSERT(NProtoBuf::IsEqual(rsp, expected));
    }

    Y_UNIT_TEST(TestResolve) {
        TEnv env;
        TestResolve(env);

        UNIT_ASSERT(env.Server.GetRequestCount() > 0);
    }

    Y_UNIT_TEST(TestResolveFromCoroutine) {
        TEnv env;

        auto f = [&env](TCont*) {
            TestResolve(env);
        };

        TContExecutor executor(128 * 1024);

        executor.Create(f, "TestResolve");
        executor.Execute();

        UNIT_ASSERT(env.Server.GetRequestCount() > 0);
    }
}
