#pragma once

#include <infra/yp_service_discovery/libs/config/config.pb.h>
#include <infra/yp_service_discovery/libs/grpc/server.h>
#include <infra/yp_service_discovery/libs/service_iface/service_iface.h>

#include <infra/libs/http_service/service.h>
#include <infra/libs/sensors/sensor_group.h>
#include <infra/libs/updatable_proto_config/accessor.h>
#include <infra/libs/updatable_proto_config/holder.h>
#include <infra/libs/yp_replica/replica_objects.h>
#include <infra/libs/yp_replica/yp_replica.h>

// TODO: move sensor registry to infra/libs
#include <infra/libs/udp_metrics/sensors/sensors_registry.h>
#include <infra/libs/udp_metrics/sensors/storages/storage/storage.h>

namespace NYP::NServiceDiscovery {
    class TService: public IService {
    public:
        TService(const TConfig& config);
        ~TService();

        void Start() override;

        void Wait() override;

        void Ping(NInfra::TRequestPtr<NApi::TReqPing> request, NInfra::TReplyPtr<NApi::TRspPing> reply) override;

        void Shutdown(NInfra::TRequestPtr<NApi::TReqShutdown> request, NInfra::TReplyPtr<NApi::TRspShutdown> reply) override;

        void ReopenLog(NInfra::TRequestPtr<NApi::TReqReopenLog> request, NInfra::TReplyPtr<NApi::TRspReopenLog> reply) override;

        void Sensors(NInfra::TRequestPtr<NApi::TReqSensors> request, NInfra::TReplyPtr<NApi::TRspSensors> reply) override;

        void DynamicSensors(NInfra::TRequestPtr<NApi::TReqSensors> request, NInfra::TReplyPtr<NApi::TRspSensors> reply) override;

        void Config(NInfra::TRequestPtr<NApi::TReqConfig>, NInfra::TReplyPtr<NApi::TRspConfig> reply) override;

        void ResolveEndpoints(NInfra::TRequestPtr<NApi::TReqResolveEndpoints> request, NInfra::TReplyPtr<NApi::TRspResolveEndpoints> reply) override;

        void ResolveNode(NInfra::TRequestPtr<NApi::TReqResolveNode> request, NInfra::TReplyPtr<NApi::TRspResolveNode> reply) override;

        void ResolvePods(NInfra::TRequestPtr<NApi::TReqResolvePods> request, NInfra::TReplyPtr<NApi::TRspResolvePods> reply) override;

        template <class TReplicas>
        void ListBackups(NInfra::TRequestPtr<NApi::TReqListBackups>, NInfra::TReplyPtr<NApi::TRspListBackups>);

        void ListEndpointBackups(NInfra::TRequestPtr<NApi::TReqListBackups>, NInfra::TReplyPtr<NApi::TRspListBackups>) override;
        void ListNodeBackups(NInfra::TRequestPtr<NApi::TReqListBackups>, NInfra::TReplyPtr<NApi::TRspListBackups>) override;
        void ListPodBackups(NInfra::TRequestPtr<NApi::TReqListBackups>, NInfra::TReplyPtr<NApi::TRspListBackups>) override;

        template <class TReplicas>
        void RollbackToBackup(const TStringBuf clusterName, const NApi::TReqRollbackToBackup&, NApi::TRspRollbackToBackup&);

        void RollbackToEndpointBackup(NInfra::TRequestPtr<NApi::TReqRollbackToBackup>, NInfra::TReplyPtr<NApi::TRspRollbackToBackup>) override;
        void RollbackToNodeBackup(NInfra::TRequestPtr<NApi::TReqRollbackToBackup>, NInfra::TReplyPtr<NApi::TRspRollbackToBackup>) override;
        void RollbackToPodBackup(NInfra::TRequestPtr<NApi::TReqRollbackToBackup>, NInfra::TReplyPtr<NApi::TRspRollbackToBackup>) override;

        template <class TReplicas>
        void StartUpdates(const TStringBuf clusterName, const NApi::TReqStartUpdates&, NApi::TRspStartUpdates&);

        void StartEndpointUpdates(NInfra::TRequestPtr<NApi::TReqStartUpdates>, NInfra::TReplyPtr<NApi::TRspStartUpdates>) override;
        void StartNodeUpdates(NInfra::TRequestPtr<NApi::TReqStartUpdates>, NInfra::TReplyPtr<NApi::TRspStartUpdates>) override;
        void StartPodUpdates(NInfra::TRequestPtr<NApi::TReqStartUpdates>, NInfra::TReplyPtr<NApi::TRspStartUpdates>) override;

        template <class TReplicas>
        void StopUpdates(const TStringBuf clusterName, const NApi::TReqStopUpdates&, NApi::TRspStopUpdates&);

        void StopEndpointUpdates(NInfra::TRequestPtr<NApi::TReqStopUpdates>, NInfra::TReplyPtr<NApi::TRspStopUpdates>) override;
        void StopNodeUpdates(NInfra::TRequestPtr<NApi::TReqStopUpdates>, NInfra::TReplyPtr<NApi::TRspStopUpdates>) override;
        void StopPodUpdates(NInfra::TRequestPtr<NApi::TReqStopUpdates>, NInfra::TReplyPtr<NApi::TRspStopUpdates>) override;

    private:
        NUpdatableProtoConfig::TConfigHolder<TConfig> ConfigHolder_;
        NUpdatableProtoConfig::TAccessor<TConfig> Config_;

        NInfra::TLogger Logger_;
        NInfra::TLogger EndpointsReplicaLogger_;
        NInfra::TLogger NodeReplicaLogger_;
        NInfra::TLogger PodsReplicaLogger_;
        NInfra::TLogger AdminHttpServiceLogger_;
        NInfra::TLogger DiscoveryHttpServiceLogger_;
        const NInfra::TSensorGroup SensorGroup_;
        const NInfra::TSensorGroup ResolveEndpointsSensorGroup_;
        const NInfra::TSensorGroup ResolveNodeSensorGroup_;
        const NInfra::TSensorGroup ResolvePodsSensorGroup_;
        const NInfra::TSensorGroup AdminHttpServiceSensorGroup_;
        const NInfra::TSensorGroup DiscoveryHttpServiceSensorGroup_;

        NInfra::THttpService AdminHttpService_;
        NInfra::THttpService DiscoveryHttpService_;
        TGrpcServer GrpcServer_;

        const TString YpToken_;

        using TYPEndpointReplica = THolder<NYPReplica::TYPReplica<NYPReplica::TEndpointReplicaObject, NYPReplica::TEndpointSetReplicaObject>>;
        using TYPEndpointReplicas = THashMap<TString, TYPEndpointReplica>;

        THolder<IThreadPool> ReplicasManagementPool_;
        TYPEndpointReplicas YPEndpointReplicas_; // Cluster name --> YPEndpointReplica_

        using TYPPodReplica = THolder<NYPReplica::TYPReplica<NYPReplica::TPodReplicaObject>>;
        using TYPPodReplicas = THashMap<TString, TYPPodReplica>;

        TYPPodReplicas YPPodReplicas_;

        using TYPNodeReplica = THolder<NYPReplica::TYPReplica<NYPReplica::TPodWithNodeIdKeyReplicaObject>>;
        using TYPNodeReplicas = THashMap<TString, TYPNodeReplica>;

        TYPNodeReplicas YPNodeReplicas_;

        THashMap<TStringBuf, NInfra::TRateSensor> Sensors_;

        NUdpMetrics::NSensors::TSensorsRegistry<NUdpMetrics::NSensors::TSensorsStorage> LimitedSensorsStorage_;

        void InitSensors(const TConfig& config);

        void PrintSensors(TStringOutput& stream) const;
        void PrintDynamicSensors(TStringOutput& stream) const;

        void LockSelfMemory();

        void StartReplicas();
        void StopReplicas();

        template <class TReplicas>
        void SwitchConfigsCallback(const TConfig& oldConfig, const TConfig& newConfig);

        template <class TReplicas>
        const TReplicas& GetReplicas() const {
            if constexpr (std::is_same<TReplicas, TYPEndpointReplicas>::value) {
                return YPEndpointReplicas_;
            } else if constexpr (std::is_same<TReplicas, TYPPodReplicas>::value) {
                return YPPodReplicas_;
            } else if constexpr (std::is_same<TReplicas, TYPNodeReplicas>::value) {
                return YPNodeReplicas_;
            } else {
                ythrow NInfra::TNotImplementedError() << "Unknown replicas holder type"; // Need more appropriate exception type
            }
        }

        NInfra::TLogger* GetLogger() override;

        template <class TReplicas>
        static const auto& GetClusterConfigs(const TConfig&);
    };

}
