#pragma once

#include <infra/yp_service_discovery/api/api.pb.h>
#include <infra/yp_service_discovery/api/internal.pb.h>
#include <infra/yp_service_discovery/libs/service_iface/protos/service.pb.h>

#include <infra/libs/version_handle/version_handle.h>
#include <infra/libs/service_iface/errors.h>
#include <infra/libs/service_iface/reply.h>
#include <infra/libs/service_iface/request.h>
#include <infra/libs/service_iface/router.h>

namespace NYP::NServiceDiscovery {
    class IApi : public NInfra::NVersionHandle::TBinaryApi {
    public:
        virtual ~IApi() = default;

        virtual void Ping(NInfra::TRequestPtr<NApi::TReqPing>, NInfra::TReplyPtr<NApi::TRspPing>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Shutdown(NInfra::TRequestPtr<NApi::TReqShutdown>, NInfra::TReplyPtr<NApi::TRspShutdown>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ReopenLog(NInfra::TRequestPtr<NApi::TReqReopenLog>, NInfra::TReplyPtr<NApi::TRspReopenLog>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Sensors(NInfra::TRequestPtr<NApi::TReqSensors>, NInfra::TReplyPtr<NApi::TRspSensors>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void DynamicSensors(NInfra::TRequestPtr<NApi::TReqSensors>, NInfra::TReplyPtr<NApi::TRspSensors>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ResolveEndpoints(NInfra::TRequestPtr<NApi::TReqResolveEndpoints>, NInfra::TReplyPtr<NApi::TRspResolveEndpoints>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ResolveNode(NInfra::TRequestPtr<NApi::TReqResolveNode>, NInfra::TReplyPtr<NApi::TRspResolveNode>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ResolvePods(NInfra::TRequestPtr<NApi::TReqResolvePods>, NInfra::TReplyPtr<NApi::TRspResolvePods>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void Config(NInfra::TRequestPtr<NApi::TReqConfig>, NInfra::TReplyPtr<NApi::TRspConfig>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ListEndpointBackups(NInfra::TRequestPtr<NApi::TReqListBackups>, NInfra::TReplyPtr<NApi::TRspListBackups>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ListNodeBackups(NInfra::TRequestPtr<NApi::TReqListBackups>, NInfra::TReplyPtr<NApi::TRspListBackups>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void ListPodBackups(NInfra::TRequestPtr<NApi::TReqListBackups>, NInfra::TReplyPtr<NApi::TRspListBackups>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void RollbackToEndpointBackup(NInfra::TRequestPtr<NApi::TReqRollbackToBackup>, NInfra::TReplyPtr<NApi::TRspRollbackToBackup>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void RollbackToNodeBackup(NInfra::TRequestPtr<NApi::TReqRollbackToBackup>, NInfra::TReplyPtr<NApi::TRspRollbackToBackup>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void RollbackToPodBackup(NInfra::TRequestPtr<NApi::TReqRollbackToBackup>, NInfra::TReplyPtr<NApi::TRspRollbackToBackup>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void StartEndpointUpdates(NInfra::TRequestPtr<NApi::TReqStartUpdates>, NInfra::TReplyPtr<NApi::TRspStartUpdates>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void StartNodeUpdates(NInfra::TRequestPtr<NApi::TReqStartUpdates>, NInfra::TReplyPtr<NApi::TRspStartUpdates>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void StartPodUpdates(NInfra::TRequestPtr<NApi::TReqStartUpdates>, NInfra::TReplyPtr<NApi::TRspStartUpdates>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void StopEndpointUpdates(NInfra::TRequestPtr<NApi::TReqStopUpdates>, NInfra::TReplyPtr<NApi::TRspStopUpdates>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void StopNodeUpdates(NInfra::TRequestPtr<NApi::TReqStopUpdates>, NInfra::TReplyPtr<NApi::TRspStopUpdates>) {
            ythrow NInfra::TNotImplementedError();
        }

        virtual void StopPodUpdates(NInfra::TRequestPtr<NApi::TReqStopUpdates>, NInfra::TReplyPtr<NApi::TRspStopUpdates>) {
            ythrow NInfra::TNotImplementedError();
        }
    };

}
