import json
import juggler_sdk
import logging

from infra.yp_service_discovery.monitoring.solomon.src.util import util


def get_solomon_lag_check():
    return juggler_sdk.Check(
        host='solomon',
        service=util.get_juggler_service('solomon_lag'),
        namespace='yp.service_discovery',
        aggregator='logic_or',
        children=[
            juggler_sdk.Child(
                host='solomon_alerting_project_lag',
                service='service_discovery',
                group_type='HOST',
                instance=''
            ),
        ]
    )


def update_juggler(checks, juggler_api):
    for check in checks:
        result = juggler_api.upsert_check(check).diff.to_dict()
        logging.info('Created juggler check: {} {}'.format(check.service, check.host))
        logging.debug('Diff:\n{}'.format(json.dumps(result, indent=4)))


def apply(juggler_api):
    update_juggler([
        get_solomon_lag_check(),
    ], juggler_api)
