from infra.yp_service_discovery.monitoring.solomon.src.util import util


def enrich_with_data(result, geo, masters):
    for title, signal in [('Requests', 'requests'), ('Successes', 'successes')]:
        panels = list()
        for host in geo:
            signal_url = {
                'l.host': host,
                'l.sensor': 'yp_service_discovery.service.resolve_endpoints.{signal}'.format(signal=signal),
                'l.yp_cluster': '|'.join(masters),
            }
            chart = {
                'type': 'IFRAME',
                'title': title,
                'subtitle': host,
                'url': util.build_url(signal_url),
                'markdown': '',
                'rowspan': 0,
                'colspan': 0,
            }
            panels.append(chart)
        result['rows'].append({'panels': panels})

    for title, signal in [('Empty Responses', 'empty_responses')]:
        panels = list()
        for host in geo:
            signal_url = {
                'l.host': host,
                'l.sensor': 'yp_service_discovery.service.resolve_endpoints.{signal}'.format(signal=signal),
                'l.yp_cluster': '|'.join(masters),
                'l.endpoint_set_id': 'any',
            }
            chart = {
                'type': 'IFRAME',
                'title': title,
                'subtitle': host,
                'url': util.build_url(signal_url),
                'markdown': '',
                'rowspan': 0,
                'colspan': 0,
            }
            panels.append(chart)
        result['rows'].append({'panels': panels})

    for title, signal in [('Access Denied', 'access_denied')]:
        panels = list()
        for host in geo:
            signal_url = {
                'l.host': host,
                'l.sensor': 'yp_service_discovery.service.resolve_endpoints.{signal}'.format(signal=signal),
            }
            chart = {
                'type': 'IFRAME',
                'title': title,
                'subtitle': host,
                'url': util.build_url(signal_url),
                'markdown': '',
                'rowspan': 0,
                'colspan': 0,
            }
            panels.append(chart)
        result['rows'].append({'panels': panels})

    for title, signal in [('Not Changed Responses', 'not_changed')]:
        panels = list()
        for host in geo:
            signal_url = {
                'l.host': host,
                'l.sensor': 'yp_service_discovery.service.resolve_endpoints.{signal}'.format(signal=signal),
                'l.yp_cluster': '|'.join(masters),
                'l.endpoint_set_id': 'any',
            }
            chart = {
                'type': 'IFRAME',
                'title': title,
                'subtitle': host,
                'url': util.build_url(signal_url),
                'markdown': '',
                'rowspan': 0,
                'colspan': 0,
            }
            panels.append(chart)
        result['rows'].append({'panels': panels})


def get_config(geo, masters):
    result = {
        'id': 'ServiceDiscovery',
        'projectId': 'service_discovery',
        'name': 'ServiceDiscovery',
        'description': '',
        'heightMultiplier': 1,
        'parameters': [],
        'rows': [
        ],
    }

    enrich_with_data(result, geo, masters)
    return result


def apply(geo, masters, solomon_api):
    config = get_config(geo, masters)
    solomon_api.put_item('dashboards', 'ServiceDiscovery', config)
