from infra.yp_service_discovery.monitoring.solomon.src.util import util


def enrich_with_data(result, geo_list, masters_list):
    # row 1-2
    for signal in ['requests', 'failures']:
        panels = list()
        for geo in geo_list:
            signal_url = {
                'min': 0,
                'max': 3,
                'l.sensor': 'yp_service_discovery.yp_replica.endpoints.master.{signal}'.format(signal=signal),
                'l.host': geo,
                'l.yp_cluster': '|'.join(masters_list),
            }

            chart = {
                'type': 'IFRAME',
                'title': 'YP Master {}'.format(signal.title()),
                'subtitle': geo.upper(),
                'url': util.build_url(signal_url),
                'markdown': '',
                'rowspan': 0,
                'colspan': 0,
            }
            panels.append(chart)
        result['rows'].append({'panels': panels})

    # row 3
    panels = list()
    for geo in geo_list:
        signal_url = {
            'min': 0,
            'max': len(masters_list) + 1,
            'l.sensor': 'yp_service_discovery.yp_replica.endpoints.backup.age_indicator',
            'l.host': geo,
            'l.yp_cluster': '|'.join(masters_list),
        }

        chart = {
            'type': 'IFRAME',
            'title': 'YP Master backup age indicator',
            'subtitle': geo.upper(),
            'url': util.build_url(signal_url),
            'markdown': '',
            'rowspan': 0,
            'colspan': 0,
        }
        panels.append(chart)
    result['rows'].append({'panels': panels})

    # row 4
    panels = list()
    for geo in geo_list:
        signal_url.update({
            'min': 0,
            'max': 10 ** 6,
            'stack': False,
            'l.sensor': 'yp_service_discovery.yp_replica.endpoints.backup.age',
            'l.host': geo,
            'l.yp_cluster': '|'.join(masters_list),
        })

        chart = {
            'type': 'IFRAME',
            'title': 'YP Master backup age',
            'subtitle': geo.upper(),
            'url': util.build_url(signal_url),
            'markdown': '',
            'rowspan': 0,
            'colspan': 0,
        }
        panels.append(chart)
    result['rows'].append({'panels': panels})

    # row 5-7
    for (signal, title) in [
            ('storage.sst_files_size_bytes', 'SST files size'),
            ('storage.size_bytes', 'storage size'),
            ('backup.size_bytes', 'backup size')]:
        panels = list()
        for geo in geo_list:
            signal_url = {
                'l.sensor': 'yp_service_discovery.yp_replica.endpoints.{signal}'.format(signal=signal),
                'l.host': geo,
                'l.yp_cluster': '|'.join(masters_list),
            }

            chart = {
                'type': 'IFRAME',
                'title': 'YP Master {}'.format(title),
                'subtitle': geo.upper(),
                'url': util.build_url(signal_url),
                'markdown': '',
                'rowspan': 0,
                'colspan': 0,
            }
            panels.append(chart)
        result['rows'].append({'panels': panels})


def get_config(geo, masters):
    result = {
        "id": "YPReplica",
        "projectId": "service_discovery",
        "name": "YPReplica",
        "description": "",
        "heightMultiplier": 1,
        "parameters": [],
        'rows': [
        ],
    }

    enrich_with_data(result, geo, masters)
    return result


def apply(geo, masters, solomon_api):
    config = get_config(geo, masters)
    solomon_api.put_item('dashboards', 'YPReplica', config)
