import json
import logging
import requests


class SolomonApi:
    def __init__(self, project_id, token):
        self.project_id = project_id
        self.headers = {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'Authorization': 'OAuth {}'.format(token),
        }

    def put_item(self, item, name, data):

        url = 'http://solomon.yandex.net/api/v2/projects/{}/{}/{}'.format(self.project_id, item, name)

        resp = requests.get(url, headers=self.headers, timeout=10)

        logging.debug(json.dumps(resp.json(), indent=4))
        update_func = requests.put
        old_version = 0
        if resp.status_code == 404:
            update_func = requests.post
            url = 'http://solomon.yandex.net/api/v2/projects/{}/{}'.format(self.project_id, item)
        else:
            resp.raise_for_status()
            old_version = resp.json()['version']

        data['version'] = old_version
        logging.debug(json.dumps(data, indent=4))
        resp = update_func(url, headers=self.headers, json=data, timeout=10)
        logging.debug(json.dumps(resp.json(), indent=4))
        resp.raise_for_status()

        logging.info('Success creation of {} with version {}'.format(name, old_version + 1))
