import juggler_sdk


def get_juggler_service(service_id):
    return '.'.join(['yp', 'service_discovery', service_id])


def solomon_lag_checks():
    return ["solomon:{}".format(get_juggler_service('solomon_lag'))]


def yp_unreach_checks(master):
    return ["yp-{}.yp.yandex.net:yp.infra.auto_downtime_".format(master)]


def standard_unreach_checks(master):
    return yp_unreach_checks(master) + solomon_lag_checks()


def get_duty_logins():
    return [
        '@svc_service_discovery:yp-service-discovery-duty',
    ]


def get_system_logins():
    return [
        'dns-monitoring',
    ]


def notification(status, logins, notify_methods, business_time_only=False):
    template_kwargs = {
        "status": status,
        "login": logins,
        "method": notify_methods,
    }

    if business_time_only:
        template_kwargs["time_start"] = "11:00"
        template_kwargs["time_end"] = "20:00"

    if (isinstance(status, str) and status == "CRIT") or (isinstance(status, dict) and status["to"] == "CRIT"):
        template_kwargs["repeat"] = 1800  # 30 min

    return juggler_sdk.NotificationOptions(
        template_name="on_status_change",
        template_kwargs=template_kwargs,
    )


def build_url(params):
    url = {
        'project': 'service_discovery',
        'cluster': 'main',
        'service': 'production',
        'graph': 'auto',
    }
    url.update(params)
    return '?' + '&'.join(map(lambda item: '='.join(map(str, item)), url.items()))
