#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/response.h>
#include <library/cpp/http/misc/parsed_request.h>

class TReplier: public TRequestReplier {
public:
    TReplier(const TString& version)
        : Version_(version)
    {
    }

    bool DoReply(const TReplyParams& params) override {
        const TParsedHttpFull parsed(params.Input.FirstLine());
        const TString postData = params.Input.ReadAll();

        THttpResponse response;

        if (parsed.Path == "/ping") {
            response.SetContent("pong");
        } else if (parsed.Path == "/version") {
            response.SetContent(Version_);
        } else {
            response = THttpResponse(HTTP_NOT_FOUND);
        }

        params.Output << response;

        return true;
    }

private:
    TString Version_;
};

class TFactory: public THttpServer::ICallBack {
public:
    TFactory(const TString& version)
        : Version_(version)
    {
    }

    TClientRequest* CreateClient() override {
        return new TReplier(Version_);
    }

private:
    TString Version_;
};

int main(int argc, const char* argv[]) {
    Y_VERIFY(argc >= 2);

    THttpServer::TOptions opts;
    opts
        .SetPort(3388)
        .SetThreads(1)
        .EnableKeepAlive(false)
        .EnableCompression(false)
        .SetClientTimeout(TDuration::Seconds(1))
        .SetMaxConnections(4)
        .SetMaxQueueSize(10);

    TFactory factory(argv[1]);
    THttpServer server(&factory, opts);

    server.Start();
    server.Wait();

    return 0;
}
