#include <infra/yp_service_discovery/libs/sdlib/http_resolver.h>
#include <infra/yp_service_discovery/libs/sdlib/grpc_resolver/grpc_resolver.h>

#include <util/stream/output.h>

using namespace NYP::NServiceDiscovery;

int main(int argc, char** argv) {
    TString protocol, cluster, endpointset;
    if (argc < 4) {
        Cerr << "./resolver [grpc|http] cluster endpointset\n";
        return -1;
    }

    protocol = TString(argv[1]);
    cluster = TString(argv[2]);
    endpointset = TString(argv[3]);


    TSDConfig config;

    IRemoteRequesterPtr resolver;
    if (protocol == "http") {
        resolver = MakeAtomicShared<THttpResolver>(config, TDuration::MilliSeconds(50), TDuration::MilliSeconds(100));
    } else {
        config.SetPort(8081);
        resolver = MakeAtomicShared<TGrpcResolver>(config, TDuration::MilliSeconds(100));
    }

    resolver->Init();

    NApi::TReqResolveEndpoints req;
    req.set_cluster_name(cluster);
    req.set_endpoint_set_id(endpointset);
    req.set_client_name("sdlib/resolver");

    TResolveRequestBatch request;
    request.push_back(req);

    TResolveResultBatch result;
    TStatEnv stat;
    resolver->Resolve(request, result, stat);

    for (const auto& r : result) {
        Cout << r.Result.DebugString() << Endl;
    }

    return 0;
}
