#include <infra/yp_service_discovery/api/api.pb.h>
#include <infra/yp_service_discovery/resolver/resolver.h>

#include <library/cpp/logger/global/global.h>

#include <util/thread/pool.h>
#include <util/system/hostname.h>
#include <util/system/user.h>

using namespace NServiceDiscovery;

constexpr size_t THREAD_COUNT = 16;

const TString CLIENT_NAME = TString::Join(GetUsername(), "@", HostName());
const TString SD_GRPC_ADDRESS = "yp-service-discovery-test-2.sas.yp-c.yandex.net:8080";

// query params
constexpr TStringBuf CLUSTER = "man";
constexpr TStringBuf ESID = "production-noapache-man-web-yp";

int main() {
    InitGlobalLog2Console();
    INFO_LOG << "Shoot Service Discovery on address " << SD_GRPC_ADDRESS << " by gRPC" << Endl;
    INFO_LOG << "Client name: " << CLIENT_NAME << Endl;

    THolder<IThreadPool> pool = CreateThreadPool(THREAD_COUNT);
    for (size_t i = 0; i < THREAD_COUNT; ++i) {
        pool->SafeAddFunc([] {
            TResolver resolver(CLIENT_NAME, SD_GRPC_ADDRESS);
            while (true) {
                try {
                    auto resp = resolver.Resolve(CLUSTER, ESID);
                    Y_ENSURE(resp.resolve_status() == NYP::NServiceDiscovery::NApi::OK);
                } catch (...) {
                    ERROR_LOG << "An error occurred: " << CurrentExceptionMessage() << Endl;
                }
            }
        });
    }
}
