#include <infra/yp_yandex_dns_export/libs/daemon/main.h>

#include <infra/libs/logger/log_printer.h>
#include <infra/libs/sensors/sensor_registry.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    NInfra::SetSensorRegistryCommonGroup({"yp_yandex_dns_export"});

    TModChooser modChooser;

    modChooser.AddMode(
        "run",
        NInfra::NYandexDnsExport::RunDaemon,
        "Run YpYandexDnsExport daemon."
    );

    modChooser.AddMode(
        "print_log",
        NInfra::PrintEventLog,
        "Print YpYandexDnsExport log."
    );

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
