#pragma once

#include <infra/yp_yandex_dns_export/libs/util/regexp.h>
#include <infra/yp_yandex_dns_export/libs/zones_list_retrievers/retrieving_zones_list.h>

#include <infra/libs/controller/object_manager/object_manager.h>

namespace NInfra::NYandexDnsExport {

////////////////////////////////////////////////////////////////////////////////

class TDynamicZonesExportManager : public NController::ISingleClusterObjectManager {
public:
    TDynamicZonesExportManager(
        TVector<NYP::NClient::TDnsZone> existingZones,
        THashMap<TString, TZonesListSnapshot> acutalZonesLists,
        const IMatcher& zonesFilterMatcher
    );

    TString GetObjectId() const override final;

    void GenerateYpUpdates(
        const NController::IObjectManager::TDependentObjects& dependentObjects,
        TVector<NController::IObjectManager::TRequest>& requests,
        TLogFramePtr logFrame
    ) const override final;

private:
    TVector<NYP::NClient::TSetRequest> GenerateUpdates(
        const NYP::NClient::TDnsZone& existing,
        const NYP::NClient::TDnsZone& actual,
        NInfra::TLogFramePtr logFrame
    ) const;

    TVector<NYP::NClient::TSetRequest> GenerateUpdates(
        const NYP::NClient::TDnsZone& existing,
        const TNothing& actual,
        const TInstant minSourceTimestamp,
        NInfra::TLogFramePtr logFrame
    ) const;

private:
    mutable TVector<NYP::NClient::TDnsZone> ExistingZones_;
    THashMap<TString, TZonesListSnapshot> ActualZonesLists_;
    const IMatcher& ZonesFilterMatcher_;
};

////////////////////////////////////////////////////////////////////////////////

class TDynamicZonesExportManagersFactory
    : public NController::ISingleClusterObjectManagersFactory
{
    using TObjectManagerOrError = TExpected<NController::TSingleClusterObjectManagerPtr, TValidationError>;

public:
    TDynamicZonesExportManagersFactory(
        TDnsZonesListExportConfig config,
        NRetrievers::TRetrievingZonesLists retrievingZonesLists
        , NController::TClientConfig ypClientConfig
        , NController::TShardPtr shard
    );

    TMaybe<NController::TClientConfig> GetYpClientConfig() const override;

    TVector<NController::ISingleClusterObjectManager::TSelectArgument> GetSelectArguments(
        const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */,
        NInfra::TLogFramePtr /* logFrame */
    ) const override final;

    TVector<TObjectManagerOrError> GetSingleClusterObjectManagers(
        const TVector<NController::TSelectObjectsResultPtr>& selectorResults,
        TLogFramePtr logFrame
    ) const override final;

private:
    TZonesListSnapshot RetrieveZonesList(
        const TString& sourceName,
        const NRetrievers::TRetrievingZonesList* retrievingZonesList,
        NInfra::TLogFramePtr logFrame
    ) const;

    TZonesListSnapshot DoRetrieveZonesList(
        const TString& sourceName,
        const NRetrievers::TRetrievingZonesList* retrievingZonesList,
        NInfra::TLogFramePtr logFrame
    ) const;

    TVector<NYP::NClient::TDnsZone> MakeZonesList(
        NController::TSelectObjectsResultPtr selectObjectsResult
    ) const;

private:
    const TDnsZonesListExportConfig Config_;
    const NController::TClientConfig YpClientConfig_;

    NRetrievers::TRetrievingZonesLists RetrievingZonesLists_;

    THolder<IMatcher> ZonesFilterMatcher_;
};

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra::NYandexDnsExport
