#include "main.h"

#include <infra/yp_yandex_dns_export/libs/config/config.pb.h>
#include <infra/yp_yandex_dns_export/libs/controller/controller.h>
#include <infra/yp_yandex_dns_export/libs/controller/dynamic_zones_export_controller.h>
#include <infra/yp_yandex_dns_export/libs/service/service.h>
#include <infra/yp_yandex_dns_export/libs/zone_receivers/receiving_zone.h>
#include <infra/yp_yandex_dns_export/libs/zone_retrievers/retrieving_zone.h>
#include <infra/yp_yandex_dns_export/libs/zones_list_retrievers/retrieving_zones_list.h>

#include <infra/libs/controller/config/config.pb.h>
#include <infra/libs/controller/daemon/main.h>
#include <infra/libs/controller/object_manager/object_manager.h>

#include <library/cpp/proto_config/load.h>

namespace NInfra::NYandexDnsExport {

int RunDaemon(int argc, const char* argv[]) {
    const TConfig config = NProtoConfig::GetOpt<TConfig>(argc, argv, "/proto_config/config.json");

    const NReceivers::TReceivingZones receivingZones =
        NReceivers::InitReceivingZones(config.GetExportConfig());
    const NRetrievers::TRetrievingZones retrievingZones =
        NRetrievers::InitRetrievingZones(config.GetExportConfig());
    const NRetrievers::TRetrievingZonesLists retrievingZonesLists =
        NRetrievers::InitRetrievingZonesList(config.GetZonesListExportConfig());

    TVector<NController::TObjectManagersFactoryPtr> objectFactories;

    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader());

    const size_t sourcesForRecordsNumber = receivingZones.size() + retrievingZones.size();
    if (sourcesForRecordsNumber > 0) {
        for (const TString& ypAddress : config.GetYpAddresses()) {
            NController::TClientConfig ypClientConfig = config.GetController().GetYpClient();
            ypClientConfig.SetAddress(ypAddress);

            objectFactories.push_back(new NYandexDnsExport::TZoneRecordsExportManagerFactory(config.GetExportConfig(), receivingZones, retrievingZones, std::move(ypClientConfig), shardsFactory.GetShard(0)));
        }
    }

    const size_t sourcesForZonesNumber = retrievingZonesLists.size();
    if (sourcesForZonesNumber > 0) {
        for (const TString& ypAddress : config.GetYpAddresses()) {
            NController::TClientConfig ypClientConfig = config.GetController().GetYpClient();
            ypClientConfig.SetAddress(ypAddress);

            objectFactories.push_back(
                new NYandexDnsExport::TDynamicZonesExportManagersFactory(
                    config.GetZonesListExportConfig(),
                    retrievingZonesLists,
                    std::move(ypClientConfig),
                    shardsFactory.GetShard(0)));
        }
    }

    const NUpdatableProtoConfig::TConfigHolderConfig& updatableConfigOpts = config.GetController().GetUpdatableConfigOptions();

    NUpdatableProtoConfig::TConfigHolderPtr<TConfig> configHolder = NUpdatableProtoConfig::CreateConfigHolder(config, updatableConfigOpts);

    return NController::RunDaemon<TService>(
        configHolder->Accessor<NController::TControllerConfig>("Controller"),
        std::move(objectFactories),
        receivingZones,
        retrievingZones,
        retrievingZonesLists
    );
}

} // namespace NInfra::NYandexDnsExport
