#include "router_api.h"

#include <infra/libs/controller/service_iface/service.h>
#include <infra/libs/service_iface/str_iface.h>

namespace NInfra::NYandexDnsExport {

TRequestRouterPtr CreateRouter(IService& service, const NReceivers::TReceivingZones& receivingZones) {
    auto router = NController::CreateRouter(service);

    (*static_cast<TRequestRouter<IService>*>(router.Get()))
        .Add<TEmptyRequest<NApi::TReqCheckIsLeader>, TRawDataReply<NApi::TRspCheckIsLeader>>("/check_is_leader", "Check that this instance is leader", &IService::CheckIsLeader);

    for (const auto& [name, zone] : receivingZones) {
        (*static_cast<TRequestRouter<IService>*>(router.Get()))
            .Add<TJsonRequest, TRawDataReply<NApi::TRspReceiveZone>>(zone->HandlerPath(), TString::Join("Source ", zone->SourceName()), &IService::ReceiveZone);
    }

    return router;
}

} // namespace NInfra::NYandexDnsExport
