#include "sensors.h"

namespace NInfra::NYandexDnsExport::NSensors {

NMonitoring::IHistogramCollectorPtr DefaultExponentialHistogram() {
    return NMonitoring::ExponentialHistogram(NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT, 1.5, 2.5);
}

NMonitoring::IHistogramCollectorPtr MakeRequestDurationHistogram() {
    return NMonitoring::ExponentialHistogram(NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT, REQUEST_DURATION_HISTOGRAM_BASE, REQUEST_DURATION_HISTOGRAM_SCALE);
}

NMonitoring::IHistogramCollectorPtr MakeResponseSizeHistogram() {
    return NMonitoring::ExponentialHistogram(NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT, RESPONSE_SIZE_HISTOGRAM_BASE, RESPONSE_SIZE_HISTOGRAM_SCALE);
}

} // namespace NInfra::NYandexDnsExport::NSensors
