#pragma once

#include <infra/libs/sensors/sensor.h>

#include <util/generic/strbuf.h>

namespace NInfra::NYandexDnsExport::NSensors {

constexpr TStringBuf RETRIEVE_GROUP_NAME = "retrieve";
constexpr TStringBuf RETRIEVE_ZONES_GROUP_NAME = "retrieve_zones";
constexpr TStringBuf RECEIVE_GROUP_NAME = "receive";

constexpr TStringBuf ZONE_EXPORT_MANAGER_GROUP_NAME = "zone_export_manager";
constexpr TStringBuf SERVICE_GROUP_NAME = "service";

constexpr TStringBuf UNKNOWN_OBTAINING_TYPE = "unknown_obtaining_type";

constexpr TStringBuf RETRIEVE_DURATION = "duration_mcs";
constexpr TStringBuf RETRIEVE_NUMBER = "retrieves";
constexpr TStringBuf RETRIEVE_SUCCESS = "success";
constexpr TStringBuf RETRIEVE_FAILED = "failed";

constexpr TStringBuf RECEIVE_DURATION = "duration_mcs";
constexpr TStringBuf RECEIVE_NUMBER = "receives";
constexpr TStringBuf RECEIVE_SUCCESS = "success";
constexpr TStringBuf RECEIVE_FAILED = "failed";

constexpr TStringBuf RECEIVE_PARSE_ERROR = "parse_error";
constexpr TStringBuf RECORD_ZONE_MISMATCH = "record_zone_mismatch";
constexpr TStringBuf RECORD_OF_UNKNOWN_ZONE = "record_of_unknown_zone";

constexpr TStringBuf HTTP_REQUEST = "http_request";
constexpr TStringBuf HTTP_REQUEST_NUMBER = "requests";
constexpr TStringBuf HTTP_REQUEST_SUCCESS = "success";
constexpr TStringBuf HTTP_REQUEST_ERROR = "error";
constexpr TStringBuf HTTP_REQUEST_FAILED = "failed";
constexpr TStringBuf HTTP_REQUEST_TIMED_OUT = "timed_out";
constexpr TStringBuf HTTP_REQUEST_DURATION = "duration_mcs";
constexpr TStringBuf HTTP_REQUEST_RESPONSE_SIZE = "response_size";

constexpr TStringBuf RESPONSE_PARSE_ERROR = "response_parse_error";

constexpr TStringBuf GENERATE_UPDATES = "generate_updates";

constexpr static double DEFAULT_HISTOGRAM_BASE = 1.5;
constexpr static double DEFAULT_HISTOGRAM_SCALE = 2.5;

NMonitoring::IHistogramCollectorPtr DefaultExponentialHistogram();

constexpr static double REQUEST_DURATION_HISTOGRAM_BASE = 1.5;
constexpr static double REQUEST_DURATION_HISTOGRAM_SCALE = 2.5;

NMonitoring::IHistogramCollectorPtr MakeRequestDurationHistogram();

constexpr static double RESPONSE_SIZE_HISTOGRAM_BASE = 1.5;
constexpr static double RESPONSE_SIZE_HISTOGRAM_SCALE = 2.5;

NMonitoring::IHistogramCollectorPtr MakeResponseSizeHistogram();

} // namespace NInfra::NYandexDnsExport::NSensors
