#pragma once

#include <infra/yp_yandex_dns_export/api/api.pb.h>

#include <infra/yp_yandex_dns_export/libs/service_iface/service.h>
#include <infra/yp_yandex_dns_export/libs/zone_receivers/receiving_zone.h>
#include <infra/yp_yandex_dns_export/libs/zone_retrievers/retriever.h>
#include <infra/yp_yandex_dns_export/libs/zone_retrievers/retrieving_zone.h>
#include <infra/yp_yandex_dns_export/libs/zones_list_retrievers/retriever.h>
#include <infra/yp_yandex_dns_export/libs/zones_list_retrievers/retrieving_zones_list.h>

#include <infra/libs/background_thread/background_thread.h>
#include <infra/libs/sensors/sensor_group.h>

#include <util/thread/pool.h>

namespace NInfra::NYandexDnsExport {

class TService: public IService {
public:
    TService(
        const THttpServiceConfig& cfg,
        TLogger& logger,
        NController::TControllerLoop& controller,
        const NReceivers::TReceivingZones& receivingZones,
        const NRetrievers::TRetrievingZones& retrievingZones,
        const NRetrievers::TRetrievingZonesLists& retrievingZonesLists
    );

    void Ping(TRequestPtr<NController::TReqPing> request, TReplyPtr<NController::TRspPing> reply) override;

    void CheckIsLeader(TRequestPtr<NApi::TReqCheckIsLeader> request, TReplyPtr<NApi::TRspCheckIsLeader> reply) override;

    void ReceiveZone(TRequestPtr<NJson::TJsonValue> request, TReplyPtr<NApi::TRspReceiveZone> reply) override;

private:
    void InitSensors();

    void RetrieveZone(const TString& sourceName, const NRetrievers::IZoneRetriever* retriever) const;

    void RetrieveZonesList(const TString& sourceName, const NRetrievers::IZonesListRetriever* retriever) const;

private:
    const NReceivers::TReceivingZones ReceivingZones_;
    const NRetrievers::TRetrievingZones RetrievingZones_;
    const NRetrievers::TRetrievingZonesLists RetrievingZonesLists_;
    const TSensorGroup SensorGroup_;

    TVector<THolder<NRetrievers::IZoneRetriever>> ZoneRetrievers_;
    TVector<THolder<NRetrievers::IZonesListRetriever>> ZonesListRetrievers_;
    TThreadPool RetrieversPool_;
    TVector<THolder<NInfra::IBackgroundThread>> RetrieverThreads_;
};

} // namespace NInfra::NYandexDnsExport
