#pragma once

#include <infra/contrib/pdns/power_dns/dns.hh>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

namespace NInfra::NYandexDnsExport {

DNSName BuildIp4PtrDnsAddress(const TStringBuf ip);

DNSName BuildIp6PtrDnsAddress(const TStringBuf ip);

DNSName BuildPtrDnsAddress(const TString& ip, QType forwardQtype);

DNSResourceRecord CreateRecord(const DNSName& qname, const TString& content, QType qtype, ui32 ttl = 0);

DNSResourceRecord CreateReverseRecord(const DNSName& qname, const TString& ip, QType qtype, ui32 ttl = 0);

TString MakeSrvContent(ui64 priority, ui64 weight, ui64 port, TStringBuf target);

TString MakeSrvContent(ui64 priority, ui64 weight, ui64 port, const DNSName& target);

} // namespace NInfra::NYandexDnsExport
