#include "regexp.h"

#include <contrib/libs/re2/include/re2/re2.h>

namespace NInfra::NYandexDnsExport {

////////////////////////////////////////////////////////////////////////////////

class TConstMatcher : public IMatcher {
public:
    TConstMatcher(bool result)
        : Result_(result)
    {
    }

    bool Match(const TStringBuf text) const override {
        Y_UNUSED(text);
        return Result_;
    }

private:
    bool Result_;
};

////////////////////////////////////////////////////////////////////////////////

class TAnyPatternMatcher : public IMatcher {
public:
    TAnyPatternMatcher(const TVector<TString>& patterns) {
        Patterns_.reserve(patterns.size());
        for (const TString& pattern : patterns) {
            Patterns_.push_back(MakeHolder<re2::RE2>(pattern));
        }
    }

    bool Match(const TStringBuf text) const override {
        for (const auto& pattern : Patterns_) {
            if (re2::RE2::FullMatch(text, *pattern)) {
                return true;
            }
        }
        return false;
    }

private:
    TVector<THolder<re2::RE2>> Patterns_;
};

////////////////////////////////////////////////////////////////////////////////

THolder<IMatcher> CreateConstMatcher(bool result) {
    return MakeHolder<TConstMatcher>(result);
}

THolder<IMatcher> CreateAnyPatternMatcher(const TVector<TString>& patterns) {
    return MakeHolder<TAnyPatternMatcher>(patterns);
}

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra::NYandexDnsExport
