#pragma once

#include <util/generic/ptr.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NInfra::NYandexDnsExport {

////////////////////////////////////////////////////////////////////////////////

class IMatcher {
public:
    virtual bool Match(const TStringBuf text) const = 0;

    virtual ~IMatcher() = default;
};

////////////////////////////////////////////////////////////////////////////////

THolder<IMatcher> CreateConstMatcher(bool result);

THolder<IMatcher> CreateAnyPatternMatcher(const TVector<TString>& patterns);

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra::NYandexDnsExport
