#include "receiving_zone.h"

namespace NInfra::NYandexDnsExport::NReceivers {

TReceivingZones InitReceivingZones(const TDnsZonesExportConfig& zonesConfig) {
    TReceivingZones result;

    for (const TSource& source : zonesConfig.GetSources()) {
        if (source.HasReceive()) {
            auto receivingZone = MakeAtomicShared<TReceivingZone>(source);
            result.emplace(receivingZone->HandlerPath(), receivingZone);
        }
    }

    return result;
}

TReceivingZone::TReceivingZone(const TSource& sourceConfig)
    : SourceName_(sourceConfig.GetName())
    , Config_(sourceConfig.GetReceive())
{
}

TStringBuf TReceivingZone::SourceName() const {
    return SourceName_;
}

const TReceiveZoneConfig& TReceivingZone::ReceiveConfig() const {
    return Config_;
}

TString TReceivingZone::HandlerPath() const {
    if (Config_.HasSlayerReverse()) {
        return TString::Join("/zone/", Config_.GetSlayerReverse().GetZone(), "/content");
    }
    ythrow yexception() << "HandlerPath() is not specified for receive type one of receiving types";
}

void TReceivingZone::SetRecords(TVector<DNSResourceRecord> records) {
    TGuard<TMutex> guard(Mutex_);
    Zone_.Records = MakeAtomicShared<TVector<DNSResourceRecord>>(std::move(records));
    Zone_.Timestamp = TInstant::Now();
}

TZoneSnapshot TReceivingZone::GetSnapshot() const {
    TGuard<TMutex> guard(Mutex_);
    return Zone_;
}

} // namespace NInfra::NYandexDnsExport::NReceivers
