#pragma once

#include <infra/yp_yandex_dns_export/libs/config/config.pb.h>
#include <infra/yp_yandex_dns_export/libs/zone_source/zone_snapshot.h>

#include <infra/contrib/pdns/power_dns/dns.hh>

#include <util/datetime/base.h>
#include <util/generic/map.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>
#include <util/system/mutex.h>

namespace NInfra::NYandexDnsExport::NReceivers {

class TReceivingZone {
public:
    TReceivingZone(const TSource& sourceConfig);

    TStringBuf SourceName() const;

    const TReceiveZoneConfig& ReceiveConfig() const;

    TString HandlerPath() const;

    void SetRecords(TVector<DNSResourceRecord> records);

    TZoneSnapshot GetSnapshot() const;

private:
    const TString SourceName_;
    const TReceiveZoneConfig Config_;

    TMutex Mutex_;
    TZoneSnapshot Zone_;
};

using TReceivingZones = TMap<TString, TAtomicSharedPtr<TReceivingZone>>;

TReceivingZones InitReceivingZones(const TDnsZonesExportConfig& zonesConfig);

} // namespace NInfra::NYandexDnsExport::NReceivers
