#pragma once

#include <infra/yp_yandex_dns_export/libs/zone_receivers/receiver.h>
#include <infra/yp_yandex_dns_export/libs/zone_receivers/slayer_reverse/proto/config.pb.h>

#include <infra/libs/logger/logger.h>
#include <infra/libs/sensors/sensor.h>

#include <infra/contrib/pdns/power_dns/dns.hh>

#include <library/cpp/json/json_value.h>

namespace NInfra::NYandexDnsExport::NReceivers {

class TSlayerReverseReceiver: public IZoneReceiver {
public:
    TSlayerReverseReceiver(TSlayerReverseConfig config, TLogFramePtr logFrame, TSensorGroup sensorGroup);

    TVector<DNSResourceRecord> Receive(const NJson::TJsonValue& records) const;

    ~TSlayerReverseReceiver() override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NInfra::NYandexDnsExport::NReceivers
