#include "axfr_retriever.h"

#include <infra/libs/logger/protos/events.ev.pb.h>

#include <infra/contrib/pdns/power_dns/resolver.hh>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

namespace NInfra::NYandexDnsExport::NRetrievers {

class TAXFRRetriever::TImpl {
public:
    TImpl(const TSource& sourceConfig)
        : SourceName_(sourceConfig.GetName())
        , Config_(sourceConfig.GetRetrieve().GetAxfr())
    {
    }

    TVector<DNSResourceRecord> Retrieve(TLogFramePtr logFrame, TSensorGroup /* sensorGroup */ ) const {
        TVector<DNSResourceRecord> result;

        ComboAddress address(Config_.GetAddress().c_str(), Config_.GetPort());
        const TSIGTriplet tt;
        logFrame->LogEvent(ELogPriority::TLOG_INFO, NLogEvent::TStartAxfrRequest(Config_.GetAddress(), Config_.GetPort()));
        AXFRRetriever retriever(address, DNSName(Config_.GetZone().c_str()), tt);

        std::vector<DNSResourceRecord> records;
        while (retriever.getChunk(records)) {
            logFrame->LogEvent(ELogPriority::TLOG_INFO, NLogEvent::TAxfrChunk(records.size()));
            result.reserve(result.size() + records.size());
            std::move(records.begin(), records.end(), std::back_inserter(result));
        }

        return result;
    }

private:
    const TString SourceName_;
    const TAxfrConfig Config_;
};

TAXFRRetriever::TAXFRRetriever(const TSource& sourceConfig)
    : Impl_(MakeHolder<TImpl>(sourceConfig))
{
}

TVector<DNSResourceRecord> TAXFRRetriever::Retrieve(TLogFramePtr logFrame, TSensorGroup sensorGroup) const {
    return Impl_->Retrieve(logFrame, std::move(sensorGroup));
}

TAXFRRetriever::~TAXFRRetriever() {
}

} // namespace NInfra::NYandexDnsExport::NRetrievers
