#pragma once

#include <infra/yp_yandex_dns_export/libs/config/config.pb.h>
#include <infra/yp_yandex_dns_export/libs/zone_retrievers/retriever.h>

#include <infra/libs/logger/logger.h>
#include <infra/libs/sensors/sensor.h>

#include <infra/contrib/pdns/power_dns/dns.hh>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NInfra::NYandexDnsExport::NRetrievers {

class TAXFRRetriever : public IZoneRetriever {
public:
    TAXFRRetriever(const TSource& sourceConfig);

    TVector<DNSResourceRecord> Retrieve(TLogFramePtr logFrame, TSensorGroup sensorGroup) const override;

    ~TAXFRRetriever() override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NInfra::NYandexDnsExport::NRetrievers
