#pragma once

#include <infra/contrib/pdns/power_dns/dns.hh>

#include <infra/libs/logger/log_frame.h>
#include <infra/libs/sensors/sensor_group.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NInfra::NYandexDnsExport::NRetrievers {

class IZoneRetriever {
public:
    virtual TVector<DNSResourceRecord> Retrieve(TLogFramePtr logFrame, TSensorGroup sensorGroup) const = 0;
    virtual ~IZoneRetriever() = default;
};

} // namespace NInfra::NYandexDnsExport::NRetrievers
