#include "retrieving_zone.h"

namespace NInfra::NYandexDnsExport::NRetrievers {

TRetrievingZones InitRetrievingZones(const TDnsZonesExportConfig& zonesConfig) {
    TRetrievingZones result;

    for (const TSource& source : zonesConfig.GetSources()) {
        if (source.HasRetrieve()) {
            auto retrievingZone = MakeAtomicShared<TRetrievingZone>(source);
            result.emplace(retrievingZone->SourceName(), retrievingZone);
        }
    }

    return result;
}

TRetrievingZone::TRetrievingZone(const TSource& sourceConfig)
    : SourceName_(sourceConfig.GetName())
    , Config_(sourceConfig)
{
}

TStringBuf TRetrievingZone::SourceName() const {
    return SourceName_;
}

const TSource& TRetrievingZone::SourceConfig() const {
    return Config_;
}

void TRetrievingZone::SetRecords(TVector<DNSResourceRecord> records) {
    TGuard<TMutex> guard(Mutex_);
    Zone_.Records = MakeAtomicShared<TVector<DNSResourceRecord>>(std::move(records));
    Zone_.Timestamp = TInstant::Now();
}

TZoneSnapshot TRetrievingZone::GetSnapshot() const {
    TGuard<TMutex> guard(Mutex_);
    return Zone_;
}

} // namespace NInfra::NYandexDnsExport::NRetrievers
