#pragma once

#include <infra/yp_yandex_dns_export/libs/config/config.pb.h>
#include <infra/yp_yandex_dns_export/libs/zone_source/zone_snapshot.h>

#include <infra/contrib/pdns/power_dns/dns.hh>

#include <util/generic/vector.h>
#include <util/system/mutex.h>

namespace NInfra::NYandexDnsExport::NRetrievers {

class TRetrievingZone {
public:
    TRetrievingZone(const TSource& sourceConfig);

    TStringBuf SourceName() const;

    const TSource& SourceConfig() const;

    void SetRecords(TVector<DNSResourceRecord> records);

    TZoneSnapshot GetSnapshot() const;

private:
    const TString SourceName_;
    const TSource Config_;

    TMutex Mutex_;
    TZoneSnapshot Zone_;
};

using TRetrievingZones = TMap<TString, TAtomicSharedPtr<TRetrievingZone>>;

TRetrievingZones InitRetrievingZones(const TDnsZonesExportConfig& zonesConfig);

} // namespace NInfra::NYandexDnsExport::NRetrievers
