#include "bridge_zones_list_retriever.h"

#include <infra/libs/yp_dns/dynamic_zones/client.h>

namespace NInfra::NYandexDnsExport::NRetrievers {

class TBridgeZonesListRetriever::TImpl {
public:
    TImpl(const TZonesListSource& config)
    {
        Y_ENSURE(config.GetRetrieveConfig().HasBridge());
        ZonesManagerClient_ = MakeHolder<NYpDns::NDynamicZones::TClient>(
            config.GetRetrieveConfig().GetBridge().GetZonesManagerClientConfig(),
            MakeAtomicShared<NYpDns::NDynamicZones::TYpDnsExportServiceClient>()
        );
    }

    TVector<NYP::NClient::TDnsZone> Retrieve(
        TLogFramePtr logFrame,
        TSensorGroup sensorGroup
    ) const {
        Y_UNUSED(logFrame);
        Y_UNUSED(sensorGroup);

        const TVector<NYpDns::TZone> dynamicZones = ZonesManagerClient_->ListZones();

        TVector<NYP::NClient::TDnsZone> result;
        result.reserve(dynamicZones.size());
        for (const NYpDns::TZone& dynamicZone : dynamicZones) {
            result.emplace_back(dynamicZone.ConfigToYpDnsZoneObject());
        }

        return result;
    }

private:
    THolder<NYpDns::NDynamicZones::TClient> ZonesManagerClient_;
};

TBridgeZonesListRetriever::TBridgeZonesListRetriever(
    const TZonesListSource& sourceConfig
)
    : Impl_(MakeHolder<TImpl>(sourceConfig))
{
}

TVector<NYP::NClient::TDnsZone> TBridgeZonesListRetriever::Retrieve(
    TLogFramePtr logFrame,
    TSensorGroup sensorGroup
) const {
    return Impl_->Retrieve(logFrame, std::move(sensorGroup));
}

TBridgeZonesListRetriever::~TBridgeZonesListRetriever() = default;

} // namespace NInfra::NYandexDnsExport::NRetrievers
