#pragma once

#include <infra/yp_yandex_dns_export/libs/config/config.pb.h>
#include <infra/yp_yandex_dns_export/libs/zones_list_retrievers/bridge/proto/config.pb.h>
#include <infra/yp_yandex_dns_export/libs/zones_list_retrievers/retriever.h>

#include <infra/libs/logger/logger.h>
#include <infra/libs/sensors/sensor.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NInfra::NYandexDnsExport::NRetrievers {

class TBridgeZonesListRetriever : public IZonesListRetriever {
public:
    TBridgeZonesListRetriever(const TZonesListSource& sourceConfig);

    TVector<NYP::NClient::TDnsZone> Retrieve(
        TLogFramePtr logFrame,
        TSensorGroup sensorGroup
    ) const override;

    ~TBridgeZonesListRetriever() override;

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NInfra::NYandexDnsExport::NRetrievers
