#include "retrieving_zones_list.h"

namespace NInfra::NYandexDnsExport::NRetrievers {

TRetrievingZonesLists InitRetrievingZonesList(
    const TDnsZonesListExportConfig& zonesListConfig
) {
    TRetrievingZonesLists result;

    for (TZonesListSource source : zonesListConfig.GetSources()) {
        auto retrievingZonesList = MakeAtomicShared<TRetrievingZonesList>(std::move(source));
        result.emplace(retrievingZonesList->SourceName(), retrievingZonesList);
    }

    return result;
}

TRetrievingZonesList::TRetrievingZonesList(TZonesListSource sourceConfig)
    : SourceName_(sourceConfig.GetName())
    , Config_(std::move(sourceConfig))
{
}

TStringBuf TRetrievingZonesList::SourceName() const {
    return SourceName_;
}

const TZonesListSource& TRetrievingZonesList::SourceConfig() const {
    return Config_;
}

void TRetrievingZonesList::SetZonesList(TVector<NYP::NClient::TDnsZone> zones) {
    TGuard<TMutex> guard(Mutex_);
    ZonesList_.Zones = MakeAtomicShared<TVector<NYP::NClient::TDnsZone>>(std::move(zones));
    ZonesList_.Timestamp = TInstant::Now();
}

TZonesListSnapshot TRetrievingZonesList::GetSnapshot() const {
    TGuard<TMutex> guard(Mutex_);
    return ZonesList_;
}

} // namespace NInfra::NYandexDnsExport::NRetrievers
