#pragma once

#include <infra/yp_yandex_dns_export/libs/config/config.pb.h>
#include <infra/yp_yandex_dns_export/libs/zone_source/zones_list_snapshot.h>

#include <yp/cpp/yp/data_model.h>

#include <util/generic/map.h>
#include <util/generic/vector.h>
#include <util/system/mutex.h>

namespace NInfra::NYandexDnsExport::NRetrievers {

class TRetrievingZonesList {
public:
    TRetrievingZonesList(TZonesListSource sourceConfig);

    TStringBuf SourceName() const;

    const TZonesListSource& SourceConfig() const;

    void SetZonesList(TVector<NYP::NClient::TDnsZone> zones);

    TZonesListSnapshot GetSnapshot() const;

private:
    const TString SourceName_;
    const TZonesListSource Config_;

    TMutex Mutex_;
    TZonesListSnapshot ZonesList_;
};

using TRetrievingZonesLists = TMap<TString, TAtomicSharedPtr<TRetrievingZonesList>>;

TRetrievingZonesLists InitRetrievingZonesList(const TDnsZonesListExportConfig& zonesConfig);

} // namespace NInfra::NYandexDnsExport::NRetrievers
