#!/usr/bin/env python3
import json
import sys
import re


def parse_hpl_results(fin):
    # HPL_AI   WR01L8R2      288000   288     4     2              23.55              6.763e+05        11.53998      2          4.539e+05
    # Check 3 things, did the job complete, did the job pass or fail, what was the performance
    complete = False
    r={'status': 'unknown'}

    for line in fin.readlines():
        l = line.decode('utf-8')
        if re.search('WR', l):
            # Check if this is regular HPL or HPL-AI
            off=0
            if (l.split()[0] == "HPL_AI"):
                off=1
            r['config']=l.split()[0+off]
            r['n']=int(l.split()[1+off])
            r['nb']=int(l.split()[2+off])
            r['p']=int(l.split()[3+off])
            r['q']=int(l.split()[4+off])
            r['time']=float(l.split()[5+off])
            if (l.split()[0] == "HPL_AI"):
                r['type']='hpl_ai'
                r['gflops']=int(float(l.split()[10]))
            else:
                r['type']='hpl'
                r['gflops']=float(l.split()[6])
            r['gflops_per']=int(r['gflops'] /(r['p'] * r['q']))

        if re.search(r'\|\|Ax-b\|\|\_oo/\(eps', l):
            if l.split()[3]=='PASSED':
                r['status']='passed'
            elif l.split()[3]=='FAILED':
                r['status']='failed'
            else:
                r['status']='unknown'

        if re.search('^HOSTLIST:', l):
            r['hosts']=l.split()[1]
        if re.search('End of Tests', l):
            complete = True

    if 'type' not in r:
        r['status']='noresult'
    if not complete:
        r['status']='incomplete'

    return r


def main():
    out = sys.stdout
    for fname in sys.argv[1:]:
        with open(fname, 'rb') as fin:
            result = parse_hpl_results(fin)
            if result['status'] != 'passed':
                print("Bad job status: {}".format(result['status']))
                sys.exit(1)
            sdata = json.dumps(result, indent=4, sort_keys=True)
            out.write(sdata)


if __name__ == "__main__":
    main()
