CWD_DIR = "/slot/sandbox"

PSEUDO_BASH = """#!/bin/bash -e

export PWD="/slot/sandbox"
export HOME="/slot/sandbox"
export SHELL="/bin/bash"
export SHLVL="1"

echo "$SSH_ORIGINAL_COMMAND" >>/slot/sandbox/stderr

if [[ -n "$SSH_ORIGINAL_COMMAND" ]]; then
    bash -c "$SSH_ORIGINAL_COMMAND"
else
    exec bash
fi
""" # noqa


DEFAULT_SSH_CONFIG_TEMPLATE = """Host *
    UserKnownHostsFile /dev/null
    StrictHostKeyChecking no
"""

SSH_CONFIG_HOST_TEMPLATE = """HOST {host}
    HostName {hostname}
    User {username}
    Port {port}
"""

SSHD_CONFIG_TEMPLATE = """UsePrivilegeSeparation no
KeyRegenerationInterval 3600
ServerKeyBits 1024
LoginGraceTime 120
PermitRootLogin without-password

RSAAuthentication yes
PubkeyAuthentication yes

IgnoreRhosts yes
RhostsRSAAuthentication no
HostbasedAuthentication no

# To enable empty passwords, change to yes (NOT RECOMMENDED)
PermitEmptyPasswords no

# Change to yes to enable challenge-response passwords (beware issues with some PAM modules and threads)
ChallengeResponseAuthentication no

TCPKeepAlive yes

# Allow client to pass locale environment variables
AcceptEnv LANG LC_*

Subsystem sftp /usr/lib/openssh/sftp-server

UsePAM no
PasswordAuthentication no
PermitUserEnvironment yes

LogLevel VERBOSE

PidFile {homedir}/sshd.pid
# Use relative path in order to avoid use sudo
# Path will be resolved via /etc/passwd, so it will likely to point to /home/yt_slot_0
AuthorizedKeysFile sshd/authorized_keys
"""

PSEUDO_SSH_TEMPLATE = """#!/bin/bash
exec ssh -F {homedir}/.ssh/config -i {homedir}/.ssh/id_rsa "$@"
"""
