# coding: utf-8



from django import forms
import six

from at.common import groups
from at.common import const


class BooleanWidget(forms.CheckboxInput):

    def value_from_datadict(self, data, files, name):
        if name not in data:
            # A missing value means False because HTML form submission does not
            # send results for unselected checkboxes.
            return False
        value = data.get(name)
        # Translate true and false strings to boolean values.
        values = {
            'true': True,
            'false': False,

            # this was added
            '1': True,
            '0': False,
        }
        if isinstance(value, six.string_types):
            value = values.get(value.lower(), value)
        return bool(value)


class BooleanField(forms.BooleanField):
    widget = BooleanWidget

    def validate(self, value):
        pass


# aux_
class GetFeedIDForm(forms.Form):
    slug = forms.CharField(required=True)


class AuthenticateForm(forms.Form):
    uid = forms.IntegerField()


class GetMlSuggestForm(forms.Form):
    part = forms.CharField()


class GetPostPreviewForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField(required=False)
    access_type = forms.ChoiceField(
        choices=(
            (val, val) for val in groups.str_access_type_to_fgroup_id
        ),
        required=False,
    )
    title = forms.CharField(required=False)
    body = forms.CharField(required=False)
    rubric = forms.ChoiceField(
        required=False,
        choices=(
            ('work', 'work'),
            ('life', 'life'),
            ('hidden', 'hidden'),
        )
    )
    type = forms.CharField(required=False)
    trackback = BooleanField()
    replies = BooleanField()
    tags = forms.CharField(required=False)
    tag = forms.CharField(required=False)
    tb_feed_id = forms.IntegerField(required=False)
    form_id = forms.CharField(required=False)

    URL = forms.CharField(required=False)
    shared_post_id = forms.CharField(required=False)

    expired = forms.CharField(required=False)
    hidden = forms.CharField(required=False)
    poll_type = forms.CharField(required=False)
    poll_id = forms.CharField(required=False)

    summon = forms.CharField(required=False)

    event = forms.CharField(required=False)
    whom = forms.CharField(required=False)

    project = forms.CharField(required=False)

    carbon_copy_address = forms.CharField(required=False)
    carbon_copy_address_input = forms.CharField(required=False)

    # 'on' flag for force_unicode strange function in Entries
    pinned = forms.CharField(required=False)
    pinned_after = forms.IntegerField(required=False)


class FriendsDoAddByUIDForm(forms.Form):
    uid = forms.IntegerField()


class FriendsDoAddBulcByUIDForm(forms.Form):
    uids = forms.CharField()


class FriendsDoDeleteByUIDForm(forms.Form):
    person_id = forms.IntegerField()


class FriendsDoDeleteBulcByUIDForm(forms.Form):
    uids = forms.CharField()


class AllCommunityBlockForm(forms.Form):
    feed_id = forms.IntegerField()
    members_count = forms.IntegerField()
    moderators_count = forms.IntegerField()
    page_num = forms.IntegerField()


class AllFriendsBlockForm(forms.Form):
    feed_id = forms.IntegerField()
    friends_count = forms.IntegerField()
    want_friends_count = forms.IntegerField()
    friendees_count = forms.IntegerField()
    page_num = forms.IntegerField()


# profile
class GetPageLayoutForm(forms.Form):
    feed_id = forms.IntegerField(required=False)
    page = forms.CharField()


class SetWidgetSettingsByIDForm(forms.Form):
    feed_id = forms.IntegerField()
    show = forms.CharField()
    widget_id = forms.CharField()


class GetRecommendationsForm(forms.Form):
    uid = forms.IntegerField()
    friends_count = forms.IntegerField()
    clubs_count = forms.IntegerField()


class GetAllWidgetSettingsForm(forms.Form):
    feed_id = forms.IntegerField()


class GetProfileCategoriesByIDForm(forms.Form):
    feed_id = forms.IntegerField()
    categories = forms.CharField()


class SetProfileGroupForIDForm(forms.Form):
    feed_id = forms.IntegerField()
    category = forms.CharField()
    groups = forms.CharField()
    no_split_groups = forms.CharField(required=False)


class SetBasicFeedInfoForIDForm(forms.Form):
    feed_id = forms.IntegerField()
    title = forms.CharField(required=False)
    sex = forms.CharField(required=False)
    id = forms.CharField(required=False)


class SetMailingSettingsForm(forms.Form):
    comments_notification_mode = forms.TypedChoiceField(
        choices=list(const.LEGACY.COMMENT_MODE_OLD_NEW.items()),
        coerce=int,
    )
    digest_mode = forms.TypedChoiceField(
        choices=list(const.LEGACY.DIGEST_MODE_OLD_NEW.items()),
        coerce=int,
    )
    summons = forms.IntegerField()
    self_mailing = forms.IntegerField()
    invites = forms.IntegerField()
    moderation = forms.IntegerField()


class CanChangeStatusForm(forms.Form):
    feed_id = forms.IntegerField()


# friends
class UnjoinFromCommunityForm(forms.Form):
    uid = forms.IntegerField()
    community_feed = forms.IntegerField()


class JoinToCommunityForm(forms.Form):
    uid = forms.IntegerField()
    community_feed = forms.IntegerField()


class FindRelationsStrForm(forms.Form):
    user_ids = forms.CharField()
    feed_ids = forms.CharField()


class FindRelationsForm(forms.Form):
    person_id = forms.IntegerField()
    feed_id = forms.IntegerField()


class MassFriendingActionForm(forms.Form):
    action = forms.ChoiceField(choices=[
        ('breakup', 'breakup'),
        ('clubs-join', 'clubs-join'),
        ('clubs-leave', 'clubs-leave'),
    ])
    qu_limit = forms.IntegerField(required=False)


# items
class GetLikeDetailsForm(forms.Form):
    id = forms.CharField()
    limit = forms.IntegerField(required=False)
    offset = forms.IntegerField(required=False)


class LikePostForm(forms.Form):
    id = forms.CharField()


class LikePost2Form(forms.Form):
    id = forms.CharField()
    value = forms.IntegerField()


class UnlikePostForm(forms.Form):
    id = forms.CharField()


class RepliesDoAddForIDForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()
    type = forms.CharField(required=False)
    welcome_to_the_club = forms.CharField(required=False)
    direction = forms.CharField(required=False)
    delete_all = forms.CharField(required=False)
    parent_id = forms.IntegerField(required=False)
    comment_id = forms.IntegerField(required=False)
    tags = forms.CharField(required=False)
    tag = forms.CharField(required=False)
    trackback = forms.IntegerField(required=False)
    tb_feed_id = forms.IntegerField(required=False)
    form_id = forms.CharField(required=False)


class PostsDoAddForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField(required=False)
    access_type = forms.ChoiceField(
        required=False,
        choices=(
            (val, val) for val in groups.str_access_type_to_fgroup_id
        )
    )
    body = forms.CharField(required=False)
    replies = BooleanField()
    tags = forms.CharField(required=False)
    tag = forms.CharField(required=False)
    base_url = forms.CharField(required=False)
    form_id = forms.CharField(required=False)


class VoteForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()
    options = forms.CharField()


class DeleteCommentByFeedIDForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()
    comment_id = forms.IntegerField()


class DeletePostForIDForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()


class GetPostSafeForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()


# recent actions
class ReceivedCommentsTotalCountForm(forms.Form):
    tag = forms.CharField()


class MarkCommentNotificationsByItemIDsForm(forms.Form):
    ids_str = forms.CharField()
    mark_str = forms.CharField()


# tags
class GetTagsXMLPagedForm(forms.Form):
    person_id = forms.IntegerField()
    count = forms.IntegerField(required=False)
    page = forms.IntegerField(required=False)


class GetTagSuggestForm(forms.Form):
    person_id = forms.IntegerField()
    part = forms.CharField()


class GetTagIDForm(forms.Form):
    person_id = forms.IntegerField()
    tag_name = forms.CharField()


class GetTopTagsForm(forms.Form):
    uid = forms.IntegerField()
    pageLength = forms.IntegerField()
    tag_name = forms.CharField()
    scale = BooleanField()
    types = forms.CharField()
    pageIndex = forms.IntegerField()


class GetTagCloud2XMLForm(forms.Form):
    uid = forms.IntegerField()
    count = forms.IntegerField()


class GetTagCloudTypedForm(forms.Form):
    uid = forms.IntegerField()
    count = forms.IntegerField()
    posttypes = forms.CharField()


# community
class UpdateCommunityReqForm(forms.Form):
    feed_id = forms.IntegerField()
    premoderated = BooleanField()
    private = BooleanField()
    rubric_id = forms.IntegerField()
    is_adult = BooleanField()
    interest = forms.CharField(required=False)
    sex = forms.CharField(required=False)
    title = forms.CharField(required=False)
    title_eng = forms.CharField(required=False)
    picture_html = forms.CharField(required=False)
    mood = forms.CharField(required=False)


class CreateCommunityReqForm(forms.Form):
    slug = forms.SlugField()
    premoderated = BooleanField()
    private = BooleanField()
    rubric_id = forms.IntegerField()
    is_adult = BooleanField()
    interest = forms.CharField(required=False)
    sex = forms.CharField(required=False)
    title = forms.CharField(required=False)
    title_eng = forms.CharField(required=False)
    picture_html = forms.CharField(required=False)
    mood = forms.CharField(required=False)


class GetCommunityOptionsForm(forms.Form):
    host_person_id = forms.IntegerField()


class GetRubricsList2Form(forms.Form):
    host_person_id = forms.IntegerField()


class GetRubricWithPagerForm(forms.Form):
    rubric_id = forms.IntegerField()
    page = forms.IntegerField()
    count = forms.IntegerField()


class GetUserCommunitiesPagedLightForm(forms.Form):
    feed_id = forms.IntegerField()
    page_num = forms.IntegerField()
    page_size = forms.IntegerField()


class InviteToGroupForm(forms.Form):
    community_feed_id = forms.IntegerField()
    person_id = forms.IntegerField()
    group_name = forms.CharField()


class AcceptModerationInvitationForm(forms.Form):
    community_feed = forms.IntegerField()


GROUP_ID_CHOICES = [
    (str_id, str_id) for int_id, str_id in list(groups.GroupType._num2str.items())
]

class RemoveFromCommunityGroupForm(forms.Form):
    community_feed = forms.IntegerField()
    person_ids = forms.CharField()
    group = forms.ChoiceField(choices=GROUP_ID_CHOICES)


class DeleteCommunityForm(forms.Form):
    feed_id = forms.IntegerField()


class RestoreCommunityForm(forms.Form):
    feed_id = forms.IntegerField()


class GetCommunityMemberCountForm(forms.Form):
    feed_id = forms.IntegerField()


# statistics
class SetPostRubricForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()
    rubric = forms.CharField()


# mailing
class GetPostSubscriptionXMLForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()


class GetBlogSubscriptionXMLForm(forms.Form):
    feed_id = forms.IntegerField()


class SetBlogSubscriptionForm(forms.Form):
    feed_id = forms.IntegerField()
    notifications = BooleanField()


class SetBlogSubscriptionPublicForm(forms.Form):
    feed_id = forms.IntegerField()
    new_state = BooleanField()


class SetPostSubscriptionPublicForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()
    new_state = BooleanField()


# moderation
class BanPersonForm(forms.Form):
    feed_id = forms.IntegerField()
    uid = forms.IntegerField()


class UnbanPersonsBulcForm(forms.Form):
    feed_id = forms.IntegerField()
    uids = forms.CharField()


class GetBannedPersonsForm(forms.Form):
    feed_id = forms.IntegerField()
    page = forms.IntegerField()
    count = forms.IntegerField()


# xdecorators
class deco_GetPostRubricsForm(forms.Form):
    ids_string = forms.CharField()


class deco_GetSubscriptionsForm(forms.Form):
    ids_string = forms.CharField()


class deco_GetLikeCountsForm(forms.Form):
    ids_string = forms.CharField()


class deco_MarkModerationForm(forms.Form):
    post_coord_str = forms.CharField()


class deco_PollVotesForm(forms.Form):
    poll_id_str = forms.CharField()


class deco_FeedItemsTagsForm(forms.Form):
    feed_item_str = forms.CharField()


class deco_CommunityStatForm(forms.Form):
    uid_str = forms.CharField()


# user events
class GetUserEventsXML2Form(forms.Form):
    recipient_uid = forms.IntegerField()
    types = forms.CharField()
    exclude = forms.CharField()
    offset = forms.IntegerField()
    limit = forms.IntegerField()


class GetUserEventCountXML2Form(forms.Form):
    recipient_uid = forms.IntegerField()
    types = forms.CharField()
    exclude = forms.CharField()
    tag = forms.CharField()


class MarkUserEvents2Form(forms.Form):
    recipient_uid = forms.IntegerField()
    types = forms.CharField()
    ids = forms.CharField()
    mark_str = forms.CharField(required=False)


# trackers
class GetTrackersProjectsForm(forms.Form):
    query = forms.CharField()


class GetTrackersCandidatesForm(forms.Form):
    queue = forms.CharField()
    uid = forms.IntegerField()


# feed info
class GetFeedInfoBulcXMLStrForm(forms.Form):
    feed_id_str = forms.CharField()


class GetFeedInfoXMLForm(forms.Form):
    feed_id = forms.IntegerField()


# feeds
class GetFeedCalendarForm(forms.Form):
    feed_id = forms.IntegerField()
    post_types = forms.CharField(required=False)
    cat_id = forms.IntegerField(required=False)


class GetPopularPostsForm(forms.Form):
    tb = forms.IntegerField()
    count = forms.IntegerField()
    category = forms.ChoiceField(choices=(
        ('all', 'Вся лента'),
        ('interesting', 'Интересное'),
        ('top', 'Самое интересное'),
    ))
    metarubric = forms.ChoiceField(
        choices=(
            ('all', 'Про все'),
            ('work', 'Про работу'),
            ('life', 'Про жизнь'),
        ),
    )


class ReadFriendsLightForm(forms.Form):
    person_id = forms.IntegerField()
    tb = forms.IntegerField()
    count = forms.IntegerField()


class GetFeed2LightForm(forms.Form):
    source_id = forms.IntegerField()
    post_types_str = forms.CharField(required=False)
    cat_id = forms.IntegerField(required=False)
    count = forms.IntegerField(required=False)
    tb = forms.IntegerField(required=False)
    min_store_time = forms.IntegerField(required=False)
    max_store_time = forms.IntegerField(required=False)


class GetFeedOnModerationForm(forms.Form):
    source_id = forms.IntegerField()
    count = forms.IntegerField()
    tb = forms.IntegerField()
    min_store_time = forms.IntegerField(required=False)
    max_store_time = forms.IntegerField(required=False)


class GetFeedTrendsForm(forms.Form):
    source_id = forms.IntegerField()
    post_types_str = forms.CharField(required=False)
    count = forms.IntegerField(required=False)
    tb = forms.IntegerField(required=False)


class GetFeedPinsForm(forms.Form):
    source_id = forms.IntegerField()


class GetCommentsExForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()
    parent_id = forms.IntegerField(required=False)
    last_seen_id = forms.IntegerField(required=False)
    with_parent = BooleanField()
    limit = forms.IntegerField(required=False)


class GetSingleCommentForm(forms.Form):
    feed_id = forms.IntegerField()
    item_no = forms.IntegerField()
    comment_id = forms.IntegerField()


# club suggest
class GetClubsSuggestForm(forms.Form):
    part = forms.CharField()
    count = forms.IntegerField()


class GetDefaultClubsSuggestForm(forms.Form):
    count = forms.IntegerField()
