# -*- coding: utf-8 -*-

from datetime import datetime
from at.api.yaru import atom

CONTENTTYPE_ATOM_ENTRY = 'application/atom+xml; type=entry; charset=utf-8'
CONTENTTYPE_ATOM_FEED = 'application/atom+xml; type=feed; charset=utf-8'
etree_to_string = lambda x: atom.tostring(x, pretty_print=True, encoding='utf-8')

OLD_YAPI_NS = 'yandex:data'
YAPI_NS = 'http://api.yandex.ru/yaru/'
USERPIC_RELATION = YAPI_NS + '/relations#userpic'
MEMBER_OF_CLUBS_RELATION = YAPI_NS + '/relations#member_of_clubs'
OWNER_OF_CLUBS_RELATION = YAPI_NS + '/relations#owner_of_clubs'
FRIENDS_RELATION = YAPI_NS + '/relations#friends'
MODERATOR_OF_CLUBS_RELATION = YAPI_NS + '/relations#moderator_of_clubs'
POST_RELATION = YAPI_NS + '/relations#posts'

CLUB_MEMBERS_RELATION = YAPI_NS + '/relations#club_members'


OLD_DEFAULT_NSMAP = {None: atom.atom_ns,
                     'y': OLD_YAPI_NS,
                     'thr': 'http://purl.org/syndication/thread/1.0',
                     }

DEFAULT_NSMAP = {None: atom.atom_ns,
                 'y': YAPI_NS,
                 'thr': 'http://purl.org/syndication/thread/1.0',
                 }

XPATH_NSMAP = dict(
    atom = atom.atom_ns,
    y = YAPI_NS
    )

# свой вариант E (element maker), умеющий конвертировать базовые типы
from lxml import builder
_typemap = {
    datetime: lambda e, v: atom._strftime(v),
    int: lambda e, v: str(v),
    int: lambda e, v: str(v),
    float: lambda e, v: str(v),
}
E = builder.ElementMaker(makeelement=atom.Element,
                         typemap=_typemap,
                         )

def _qname(elementname, ns='y', old_ns=False):
    return '{%s}%s' % (DEFAULT_NSMAP[ns] if not old_ns else OLD_DEFAULT_NSMAP[ns], elementname)

def _element(elementname):
    return atom.Element(_qname(elementname))

#TODO: поддержать создание entry без id и updated?
def create_entry(id, title, updated, nsmap={}, **kw):
    # atom:entry MUST contain:
    #  * atom:id
    #  * atom:title
    #  * atom:updated
    #  * atom:content or atom:link rel='alternate'
    #  * atom:summary in some exotic cases
    #  * atom:author if not in feed
    nsmap = dict(DEFAULT_NSMAP, **nsmap)
    entry = atom.Element('entry', nsmap=nsmap)

    entry.id = id
    entry.title = title
    entry.updated = updated

    if 'content' in kw:
        #TODO: support for html, xhtml and xml content types
        entry.append(E('content', kw['content']))

    return entry

def create_feed(id, author_name, author_uri, title, updated):
    # atom:feed MUST contain:
    #  * atom:id
    #  * atom:author if enclosed entries does not specify their authors itself
    #  * atom:title
    #  * atom:updated
    #  * atom:link rel='self'
    #XXX: указывать xml:lang не так, а правильным образом
    feed = atom.Element('feed', nsmap=DEFAULT_NSMAP)#, {'xml:lang': 'ru'})
    feed.id = id
    feed.author = atom.Element('author')
    feed.author.name = author_name
    feed.author.uri = author_uri
    feed.title = title
    feed.updated = updated
    #TODO: ещё link rel=self

    return feed

if __name__ == "__main__":
    entry_data_list = [
        dict(id='1', title='Большой друг некоторых людей', updated=datetime.utcnow()),
        dict(id='2', title='Смотрящий в гробу', updated=datetime.utcnow()),
    ]

    feed = create_feed('1', 'Сундучок с нектами', 'Некты', datetime.utcnow())
    for data in entry_data_list:
        feed.append(create_entry(data['id'], data['title'], data['updated']))

    print(atom.tostring(feed, pretty_print=True))
