# -*- coding: utf-8 -*-
from django.http import HttpResponse

from at.api.yaru.person.store import PersonAtomStore
from at.api.yaru.instances import Blog, Club
from at.api.yaru.utils.django_helpers import to_canonical


def _get_atomsvc(request, feed):
    store = PersonAtomStore()
    atomsvc = store.get_atomsvc(feed)
    return HttpResponse(atomsvc, content_type='application/atomsvc+xml')


@to_canonical(Blog, 'blog_atomsvc')
def get_person_atomsvc(request, feed_id):
    return _get_atomsvc(request, Blog(feed_id, abs_url=request.build_absolute_uri))


@to_canonical(Club, 'club_atomsvc')
def get_club_atomsvc(request, feed_id):
    return _get_atomsvc(request, Club(feed_id, abs_url=request.build_absolute_uri))
