# -*- coding: utf-8 -*-
import functools
from django.http import Http404


class AccessError(Exception):
    @staticmethod
    def from_corba_assertions(assertions):
        return from_corba_assertions(AccessError, assertions)


class ConflictError(Exception):
    pass


class NotFound(Http404):
    pass


class OutOfBoundsError(Exception):
    pass


class MediaTypeError(Exception):
    pass


class InvalidInputError(Exception):
    @staticmethod
    def from_corba_assertions(assertions):
        return from_corba_assertions(InvalidInputError, assertions)


class FeedNotFound(NotFound):
    def __init__(self, message):
        self.message = 'Feed not found: %s\n' % message


class BlogNotFound(FeedNotFound):
    def __init__(self, message):
        self.message = 'Blog not found: %s\n' % message


class ClubNotFound(FeedNotFound):
    def __init__(self, message):
        self.message = 'Club not found: %s\n' % message


class EntryNotFound(NotFound):
    def __init__(self, message):
        self.message = 'Entry not found: %s\n' % message


class FixMeError(Exception):
    pass


# Все значения упёрты из http://dps.yandex.ru/edit.xml?p=friends&cnt=/posts&doc=/db/friends/posts/validation.xml
CORBA_ERRORS_MAP = {('text', 'body', 'NOT_EMPTY'): 'Content cannot be empty', # Текст не написан.
                    ('link', 'URL', 'NOT_EMPTY'): 'URL is not specified', # URL не указан.
                    ('post', 'user', 'ACCESS_DENIED'): 'You can\'t post here', # Вам запрещено писать на этой странице.
                    ('post', 'item_no', 'NOT_VALID'): 'Post not found', # Редактируемая запись не найдена.
                    ('join', 'user-already', 'NOT_VALID'): 'You already a member of this club', # Вы уже состоите в этом клубе.
                    ('unjoin', 'user-already', 'NOT_VALID'): 'You aren\'t a member of this club', # Вы не состоите в этом клубе.
                    }


def from_corba_assertions(exception, assertions):
    messages = [ CORBA_ERRORS_MAP.get((a.comment, a.name, str(a.condition))) for a in assertions ]
    message = '; '.join(m for m in messages if m) + '\n'
    return exception(message)
