# -*- coding: utf-8 -*-

from django.core.urlresolvers import reverse
from at.api.yaru.person.models import Profile
from at.api.yaru.instances import Blog
from at.api.yaru.post.store import PostAtomStore
from at.api.yaru.templates import YaruFeed, YaruProfile


class FriendsAtomStore(object):
    def __init__(self, ai, blog, abs_url=lambda url: url):
        self.abs_url = abs_url
        self.blog = blog
        self.ai = ai
        self.profile = Profile.from_feed_id(self.ai.uid)
        self.relations = None
        self.total_relations = 0

    #TODO: поддержка листания или категоризации/фильтрации нужна?
    def index(self, page_no, page_size):
        friends_count, friends = self.profile.get_relations(page_no, page_size)
        links = {'self': [{'href': self.abs_url(reverse('blog_friends', args=[self.blog.get_id()]))}]}
        if friends:
            if page_no*page_size < friends_count:
                links['next'] = [{
                    'href': self.abs_url('%s?p=%d&count=%d' % (
                        reverse('blog_friends', args=[self.blog.get_id()]
                    ), page_no+1, page_size))
                }]
        renderer = YaruFeed('urn:ya.ru:friends/%s' % self.blog.get_id(),
                            [YaruProfile(Blog(f.id, profile=f), f, is_short=True) for f in friends],
                            links)
        return renderer

    def posts_index(self, since, count, post_type=''):
        posts_store = PostAtomStore(self.ai, self.blog)
        return posts_store.friends_posts(since, count, post_type)
