# -*- coding: utf-8 -*-

from io import BytesIO

import lxml.etree as et
import elementflow

from at.api.yaru.person.models import Profile
from at.api.yaru import atom, atomgen
from at.api.yaru import urlgen
from at.api.yaru.errors import ClubNotFound, BlogNotFound, InvalidInputError, FixMeError
from at.api.yaru import datacore
from at.api.yaru.instances import Blog
from at.api.yaru.templates import YaruProfile


class PersonAtomStore(object):
    def get(self, ai, request, feed, with_tags=False):
        if ai:
            user_profile = Profile.from_feed_id(ai.uid)
            if with_tags:
                user_profile.get_tags(ai, urlgen.tag_space_url(feed, abs_url=request.build_absolute_uri))
                print(user_profile.tags)
            if not user_profile:
                raise BlogNotFound(feed.get_id())
        else:
            user_profile = None
        renderer = YaruProfile(feed, user_profile)
        return renderer

    def get_atomsvc(self, feed):
        profile = Profile.from_feed_id(0)
        if not profile:
            if feed.get_type() == 'person':
                raise BlogNotFound(feed.get_id())
            else:
                raise ClubNotFound(feed.get_id())
        xml = elementflow.xml(BytesIO(), 'service',
                              namespaces={'': 'http://www.w3.org/2007/app',
                                          'atom': 'http://www.w3.org/2005/Atom'},
                              indent=True)
        with xml:
            with xml.container('workspace'):
                xml.element('atom:title', text=feed.get_name())
                with xml.container('collection', attrs={'href': feed.get_relations()['posts'][0]['href']}):
                    xml.element('atom:title', text='List of posts')
                    xml.element('accept', text='application/atom+xml; type=entry')
                if feed.get_type() == 'person':
                    with xml.container('collection', attrs={'href': feed.get_relations()['friends_posts'][0]['href']}):
                        xml.element('atom:title', text='List of friends posts')
                        xml.element('accept')
        return xml.file.getvalue()

    def mk_profile_by_input(self, user_id, feed, input_entry, format):
        if format == 'xml':
            YAPI_NS = atomgen.YAPI_NS if input_entry.nsmap.get(None) == atomgen.YAPI_NS else atomgen.OLD_YAPI_NS
            a = lambda n: '{%s}%s' % (YAPI_NS, n)
        def get_text_xml(n):
            elem = input_entry.find(a(n))
            if elem is not None:
                return elem.text
            return None
        def get_text_json(n):
            return input_entry.get(n)

        get_text = get_text_xml if format == 'xml' else get_text_json

        profile = {}
        for attr in ['email', 'sex', 'name', 'birth_year', 'birth_month', 'birth_day',
                     'city', 'ya-online', 'icq', 'm-agent', 'g-talk', 'skype', 'website',
                     'hair', 'height', 'weight', 'smoking', 'marital', 'children',
                     'habitat', 'constitution',
                     'country', 'metro', 'mobile_phone', 'work_phone',]:
            value = get_text(attr)
            if attr in ['birth_year', 'birth_month', 'birth_day']:
                if value is not None:
                    value = int(value)
            elif attr == 'sex':
                if not value:
                    value = 'unknown'
            if attr == 'name':
                profile['signature'] = value
            else:
                profile[attr] = value
        if format == 'xml':
            languages_elem = input_entry.find(a('languages'))
            profile['languages'] = []
            if languages_elem is not None:
                languages_elems = input_entry.findall('/'.join([a('languages'), a('language')]))
                for language_elem in languages_elems:
                    value = language_elem.text
                    if value:
                        profile['languages'].append(value)
            consulting_elem = input_entry.find(a('consulting'))
            profile['consulting'] = []
            if consulting_elem is not None:
                consulting_elems = input_entry.findall('/'.join([a('consulting'), a('topic')]))
                for consulting_elem in consulting_elems:
                    value = consulting_elem.text
                    if value:
                        profile['consulting'].append(value)
            special_elem = input_entry.find(a('special'))
            profile['special'] = {}
            if special_elem is not None:
                property_elems = input_entry.findall('/'.join([a('special'), a('property')]))
                for property_elem in property_elems:
                    key = property_elem.xpath('y:key/text()', namespaces={'y': YAPI_NS})
                    value = property_elem.xpath('y:value/text()', namespaces={'y': YAPI_NS})
                    if key and value:
                        profile['special'][key[0]] = value[0]
        elif format == 'json':
            profile['languages'] = [l for l in input_entry.get('languages', [])]
            profile['consulting'] = [t for t in
                                     input_entry.get('consulting', [])]
            profile['special'] = dict(input_entry.get('special', []))

            # abilities_elem = input_entry.find(a('abilities'))
            # profile['abilities'] = []
            # if abilities_elem is not None:
            #     ability_elems = input_entry.findall('/'.join([a('abilities'), a('ability')]))
            #     for ability_elem in ability_elems:
            #         value = ability_elem.text
            #         if value:
            #             # вот так работает:
            #             profile['abilities'] = value
            #             # FIXME а вот так, не работает
            #             # profile['abilities'].append(value)
        return profile

