# coding: utf-8

from django.http import HttpResponse, HttpResponseRedirect, \
    HttpResponseBadRequest

from django.core.urlresolvers import reverse
from django.views.decorators.http import etag
from lxml.etree import XMLSyntaxError
import lxml.etree as et
import json
from hashlib import sha1

from at.api.yaru.errors import BlogNotFound, ClubNotFound
from at.api.yaru.person.store import PersonAtomStore
from at.api.yaru.person.models import Profile
from at.api.yaru.utils.django_helpers import to_canonical, require_permission, \
    require_ctypes, get_format, get_ctype
from at.api.yaru.instances import Blog, Club


def _get_format(request):
    format, forced = get_format(request, ['application/x-yaru+json',
                                          'application/x-yaru+xml'],
                                'application/x-yaru+xml')
    return format, forced


def feed_revision(request, ai, feed, with_tags=False):
    profile = Profile.from_feed_id(ai.uid, fetch_fast_profile=True)
    if profile is None:
        raise ClubNotFound(
            feed.get_id()) if feed.get_type() == 'club' else BlogNotFound(
            feed.get_id())
    return sha1(repr(list(profile.items())).encode('utf-8')).hexdigest()


def _get_feed_info(request, ai, feed, with_tags=False):
    format, forced = _get_format(request)
    renderer = PersonAtomStore().get(ai, request, feed, with_tags)
    if 'xml' in format:
        profile = renderer.to_xml(forced, render=True)
        return HttpResponse(profile, content_type='%s; type=%s' % (
        format, feed.get_type()))
    else:
        profile = renderer.to_json(forced, render=True)
        return HttpResponse(profile, content_type='%s; type=%s' % (
        format, feed.get_type()))


@to_canonical(Blog, 'blog_person')
@require_permission('yaru:read', allow_anonymous=True)
def get_person(request, feed_id):
    return _get_feed_info(
        request,
        request.ai,
        Blog(feed_id, abs_url=request.build_absolute_uri),
        False
    )


@to_canonical(Blog, 'blog_person_with_tags')
@require_permission('yaru:read', allow_anonymous=True)
def get_person_with_tags(request, feed_id):
    return _get_feed_info(request, request.ai,
                          Blog(feed_id, abs_url=request.build_absolute_uri),
                          True)


@require_permission('yaru:read')
def me(request):
    blog = Blog(request.ai.uid, abs_url=request.build_absolute_uri)
    return HttpResponseRedirect(reverse('blog_person', args=[
        blog.get_id()]) + '?' + request.GET.urlencode())
