# -*- coding: utf-8 -*-
from django.http import HttpResponseRedirect, HttpResponseBadRequest, HttpResponseNotFound
from django.core.urlresolvers import reverse, NoReverseMatch
from django.utils.http import urlencode
from at.api.yaru.errors import NotFound, InvalidInputError
from at.api.yaru import instances
from at.api.yaru.utils.django_helpers import check_post_type
import re


RE_ID = re.compile(r'urn\:ya\.ru\:(?P<type>\w+)\/(?P<params>.+)')


def url_by_id(request):
    identifier = request.GET.get('id', None)
    if not identifier:
        return HttpResponseBadRequest('Required parameter is missing: id')
    get_params_to_proxy = dict(iter(request.GET.items()))
    get_params_to_proxy.pop('id')
    m = RE_ID.match(identifier)
    NOT_FOUND = NotFound('Resource not found')
    def is_digit(x):
        if not x.isdigit():
            raise NOT_FOUND
    def is_digit_seq(xs):
        [ is_digit(x) for x in xs ]
    if m:
        url_name = None
        url_args = []
        d = m.groupdict()

        entity_type = d['type']
        params = d['params'].split('/')
        params = [ p for p in params if p ]

        if params:
            if entity_type in ['person', 'club', 'friends']:
                if len(params) == 1: # (person|club|friend)/feed_id
                    uid = params.pop(0)
                    is_digit(uid)
                    url_name = {'person': 'blog_person', 'club': 'club', 'friends': 'blog_friends'}[entity_type]
                    url_args = [uid]
                elif len(params) == 2 and entity_type == 'club':
                    try:
                        url_name = {'moderators': 'club_list_moderators',
                                    'members': 'club_list_members'}[params[1]]
                    except KeyError:
                        raise NOT_FOUND
                    url_args = [params[0]]
                elif len(params) == 3 and entity_type == 'person':
                    if params[1] == 'club':
                        try:
                            url_name = {'member': 'person_member_of_clubs',
                                        'owner': 'person_owner_of_clubs',
                                        'moderator': 'person_moderator_of_clubs'}[params[2]]
                        except KeyError:
                            raise NOT_FOUND
                        url_args = [params[0]]
                    else:
                        raise NOT_FOUND
                else:
                    raise NOT_FOUND
            elif entity_type == 'feed' and len(params) >= 2 and len(params) <= 3:
                try:
                    url_name = {'person': 'blog_posts',
                                'club': 'club_posts',
                                'friends': 'blog_friends_posts'}[params[0]]
                except KeyError:
                    raise NOT_FOUND
                if len(params) == 3:
                    try:
                        check_post_type(params[2])
                        url_name += '_by_type'
                    except NotFound:
                        raise NOT_FOUND
                is_digit(params[1])
                url_args = params[1:]
            elif entity_type == 'post':
                is_digit_seq(params)
                feed = instances.from_uid(params[0], abs_url=request.build_absolute_uri)
                if feed.get_type() == 'person':
                    url_name = 'blog_post'
                else:
                    url_name = 'club_post'
                url_args = params
            else:
                raise NOT_FOUND
        else:
            raise NOT_FOUND

        if url_name:
            try:
                redirect_to = request.build_absolute_uri(reverse(url_name, args=url_args))
                if get_params_to_proxy:
                    redirect_to += '?%s' % urlencode(get_params_to_proxy)
                return HttpResponseRedirect(redirect_to)
            except NoReverseMatch:
                pass
    raise InvalidInputError('Invalid resource id')
