# -*- coding: utf-8 -*-
'''
Методы получения адресов (URL) различных внешних и внутренних сущностей
(картинки аватарок, ресурсов персон и т.д.)
'''

import os.path
import urllib.parse
#import routes
from django.conf import settings
from django.core.urlresolvers import reverse


#XXX: узнавать базовый hostname у я.ру? можно ли?
PROFILE_PAGE_URL_PATTERN = settings.BLOGS_PERSON_PROFILE_PAGE_URL.replace('{login}', '%(login)s')
USERPIC_URL_PREFIX = settings.UPICS_URL_PREFIX


def fotki_photo_url(login, photo_id):
    return urllib.parse.urljoin(settings.FOTKI_URL_PREFIX, '/users/%s/view/%s' % (login, photo_id))

def video_url(login, storage):
    return urllib.parse.urljoin(settings.VIDEO_URL_PREFIX, '%s/%s/' % (login, storage))


def profile_page_url(login):
    ''' Строит URL HTML-страницы профиля пользователя (персоны) на я.ру. '''
    return PROFILE_PAGE_URL_PATTERN % locals()

def post_page_url(login, post_id):
    ''' Cтроит URL HTML-страницы с одной записью на я.ру '''
    return "%s/replies.xml?item_no=%s" % (profile_page_url(login), post_id)

def comment_page_url(login, post_id, comment_id):
    ''' Строит URL HTML-страницы с определенным комментом '''
    return "%s/replies.xml?item_no=%s&parent_id=%s&with_parent=1" % (profile_page_url(login), post_id, comment_id)

def userpic_url(uid, size='normal'):
    ''' Строит канонический URL аватарки пользователя на сервисе аватарок
    (https://wiki.yandex-team.ru/AndrejjTatarinov/Avatars).

    Пример: http://upics.yandex.net/get/kopatblrb/normal
    '''
    parts = [USERPIC_URL_PREFIX, str(uid)]
    if size in ('small', 'middle', 'normal'):
        parts.append(size)
    return os.path.join(*parts)


def verbose_userpic_url(uid, upic_id, size='normal'):
    parts = [settings.VERBOSE_USERPIC_URL_PREFIX, str(uid), upic_id]
    if size in ['small', 'middle', 'normal']:
        parts[-1] += '-' + size
    return os.path.join(*parts)


def verbose_userpic_url_new(uid, upic_id, size='normal'):
    if not upic_id:
        upic_id = 'stub'
    return '{}/{}/{}'.format(settings.AVATAR_GET_URL, upic_id, size)

## Не можем использовать routes.url_for, так как та использует маппирование
## от текущего request'а, и не может дать ответ о URL персоны во время обработки
## запросов, сконфигурированных не через routes (/json/, /notify/ и т.д.)
#
#def _routes_config():
#    ''' Должна вызываться только после того, как отработала ruserver.config_server() '''
#    return cherrypy.tree.apps[''].config['/']['request.dispatch']
#
#def _routes_url_for(**kw):
#    return _routes_config().mapper.generate(**kw)

#FIXME: mapper.generate тоже иногда использует контекст текущего запроса,
# который бывает странным. Пока заменил заплаткой.
def _routes_url_for(**kw):
    if kw['controller'] == 'person': return '/person/%(id)s' % kw
    if kw['controller'] == 'club': return '/club/%(id)s' % kw
    if kw['controller'] == 'property': return '/person/%(person_id)s/property/%(id)s' % kw
    if kw['controller'] == 'friend': return '/person/%(person_id)s/friend/%(id)s' % kw
    if kw['controller'] == 'post': return '/person/%(person_id)s/post/%(id)s' % kw
    if kw['controller'] == 'comment': return '/person/%(person_id)s/post/%(post_id)s/comment/%(id)s' % kw

def person_resource_url(id, abs_url=lambda url: url):
    path = _routes_url_for(controller='person', id=id, action='show')
    return abs_url(path) if path else None

def club_resource_url(id, abs_url=lambda url: url):
    path = _routes_url_for(controller='club', id=id, action='show')
    return abs_url(path) if path else None

def club_avatar_url(id, picture_id, size="normal"):
    if picture_id and picture_id is not None:
        return verbose_userpic_url(id, picture_id, size)
    return ""

def club_avatar_url_new(id, picture_id, size="normal"):
    return verbose_userpic_url_new(id, picture_id, size)

def person_subresource_url(subresource_name, person_id, id, abs_url=lambda url: url):
    path = _routes_url_for(controller=subresource_name, person_id=person_id, id=id, action='show')
    return abs_url(path) if path else None

def property_resource_url(person_id, property_id, abs_url=lambda url: url):
    return abs_url(reverse('blog_property', args=[person_id, property_id]))

def post_resource_url(person_id, post_id, abs_url=lambda url: url):
    return abs_url(reverse('blog_post', args=[person_id, post_id]))

def post_subresource_url(subresource_name, person_id, post_id, id, abs_url=lambda url: url):
    path = _routes_url_for(controller=subresource_name, person_id=person_id, post_id=post_id, id=id, action='show')
    return abs_url(path) if path else None

def comment_resource_url(person_id, post_id, id):
    return post_subresource_url('comment', person_id, post_id, id)

def tag_space_url(feed, abs_url=lambda url: url):
    if feed.get_type() == 'person':
        url = person_resource_url(feed.get_id(), abs_url=abs_url)
    else:
        url = club_resource_url(feed.get_id(), abs_url=abs_url)
    return os.path.join(url, "tag")
