# coding: utf-8

from django.conf.urls import url

from at.api.yaru.methods_dispatcher import dispatch
from at.api.yaru.person import views as person
from at.api.yaru.post import views as post
from at.api.yaru.friend import views as friend
from at.api.yaru.comment import views as comment
from at.api.yaru.club import views as club
from at.api.yaru.resource import views as resource
from at.api.yaru.atomsvc import views as atomsvc


# blogs
urlpatterns = [
    # me
    url(r'^me/$', dispatch(get=person.me), name='me'),

    # person
    url(r'^person/(?P<feed_id>[\w-]+)/tags/$', dispatch(get=person.get_person_with_tags), name='blog_person_with_tags'),
    url(r'^person/(?P<feed_id>[\w-]+)/tags/(?P<cat_id>\d+)/$', dispatch(get=post.get_blog_posts_by_category), name='blog_posts_by_category'),
    url(r'^person/(?P<feed_id>[\w-]+)/trends/$', dispatch(get=post.get_blog_trends), name='club_trends'),
    url(r'^person/(?P<feed_id>[\w-]+)/$', dispatch(get=person.get_person), name='blog_person'),
    url(r'^person/(?P<feed_id>[\w-]+)/atomsvc/$', dispatch(get=atomsvc.get_person_atomsvc), name='blog_atomsvc'),
    url(r'^person/(?P<feed_id>[\w-]+)/club/$', dispatch(get=club.member_of_clubs), name='person_member_of_clubs'),
    url(r'^person/(?P<feed_id>[\w-]+)/club/owner/$', dispatch(get=club.owner_of_clubs), name='person_owner_of_clubs'),
    url(r'^person/(?P<feed_id>[\w-]+)/club/moderator/$', dispatch(get=club.moderator_of_clubs), name='person_moderator_of_clubs'),
    # friend
    url(r'^person/(?P<feed_id>[\w-]+)/friend/$', dispatch(get=friend.index), name='blog_friends'),
    url(r'^person/(?P<feed_id>[\w-]+)/friend/post/$', dispatch(get=friend.posts_index), name='blog_friends_posts'),
    url(r'^person/(?P<feed_id>[\w-]+)/friend/post/(?P<post_type>\w+)/$', dispatch(get=friend.posts_index_by_type), name='blog_friends_posts_by_type'),
    # post
    url(r'^person/(?P<feed_id>[\w-]+)/post/$', dispatch(get=post.get_blog_posts,
                                                        post=post.create_blog_post), name='blog_posts'),
    url(r'^person/(?P<feed_id>[\w-]+)/preview/$', dispatch(post=post.preview_blog_post), name='preview_blog_posts'),
    url(r'^person/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/$', dispatch(get=post.get_blog_post,
                                                                         delete=post.delete_blog_post), name='blog_post'),
    url(r'^person/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/subscribe$', dispatch(post=post.subscribe_blog_post), name='blog_post_subscribe'),
    url(r'^person/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/unsubscribe$', dispatch(post=post.unsubscribe_blog_post), name='blog_post_unsubscribe'),
    url(r'^person/(?P<feed_id>[\w-]+)/post/(?P<post_type>\w+)/$', dispatch(get=post.get_blog_posts_by_type), name='blog_posts_by_type'),
    # comment
    url(r'^person/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/comment/$',
        dispatch(get=comment.get_blog_comment,
                 post=comment.post_blog_comment),
        name='blog_comment'),
    url(r'^person/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/comment/(?P<comment_id>\d+)$',
        dispatch(get=comment.get_blog_single_comment,
                 delete=comment.delete_blog_comment),
        name='blog_single_comment')
]

# posts
urlpatterns += [
    url(r'^posts/$', dispatch(get=post.get_recent_posts), name="recent_posts"),
]

# clubs
urlpatterns += [
    # club
    url(r'^club/(?P<feed_id>[\w-]+)/$', dispatch(get=club.get_club), name='club'),
    url(r'^club/(?P<feed_id>[\w-]+)/tags/$', dispatch(get=club.get_club_with_tags), name='club_with_tags'),
    url(r'^club/(?P<feed_id>[\w-]+)/tags/(?P<cat_id>\d+)/$', dispatch(get=post.get_club_posts_by_category), name='club_posts_by_category'),
    url(r'^club/(?P<feed_id>[\w-]+)/trends/$', dispatch(get=post.get_club_trends), name='club_trends'),
    url(r'^club/(?P<feed_id>[\w-]+)/atomsvc/$', dispatch(get=atomsvc.get_club_atomsvc), name='club_atomsvc'),
    url(r'^club/(?P<feed_id>[\w-]+)/member/$', dispatch(get=club.list_members), name='club_list_members'),
    url(r'^club/(?P<feed_id>[\w-]+)/moderator/$', dispatch(get=club.list_moderators), name='club_list_moderators'),
    url(r'^club/(?P<feed_id>[\w-]+)/moderator/ban/$', dispatch(post=club.ban_person_in_club), name='club_ban_person'),
    # post
    url(r'^club/(?P<feed_id>[\w-]+)/preview/$', dispatch(post=post.preview_club_post), name='preview_club_posts'),
    url(r'^club/(?P<feed_id>[\w-]+)/post/$', dispatch(get=post.get_club_posts,
                                                      post=post.create_club_post), name='club_posts'),
    url(r'^club/(?P<feed_id>[\w-]+)/post/(?P<min_time>\d+)/(?P<max_time>\d+)/$', dispatch(get=post.get_club_posts_by_interval), name='club_posts_by_interval'),
    url(r'^club/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/$', dispatch(get=post.get_club_post,
                                                                       delete=post.delete_club_post), name='club_post'),
    url(r'^club/(?P<feed_id>[\w-]+)/post/(?P<post_type>\w+)/$', dispatch(get=post.get_club_posts_by_type), name='club_posts_by_type'),
    url(r'^club/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/subscribe$', dispatch(post=post.subscribe_club_post), name='club_post_subscribe'),
    url(r'^club/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/unsubscribe$', dispatch(post=post.unsubscribe_club_post), name='club_post_unsubscribe'),
    # comment
    url(r'^club/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/comment/$',
        dispatch(get=comment.get_club_comment,
                 post=comment.post_club_comment),
        name='club_comment'),
    url(r'^club/(?P<feed_id>[\w-]+)/post/(?P<post_no>\d+)/comment/(?P<comment_id>\d+)$',
        dispatch(get=comment.get_club_single_comment,
                 delete=comment.delete_club_comment),
        name='club_single_comment')
]

# id -> url
urlpatterns += [
    url(r'^resource/$', dispatch(get=resource.url_by_id)),
]


handler404 = 'social.views.handler404'
handler500 = 'social.views.handler500'
